/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class DateTimeStyleFormat
implements XMLConvertible {
    public static final String DAY = "<number:day/>";
    public static final String LONG_DAY = "<number:day number:style=\"long\"/>";
    public static final String TEXTUAL_DAY = "<number:day number:textual=\"true\"/>";
    public static final String LONG_TEXTUAL_DAY = "<number:day number:style=\"long\" number:textual=\"true\"/>";
    public static final String MONTH = "<number:month/>";
    public static final String LONG_MONTH = "<number:month number:style=\"long\"/>";
    public static final String TEXTUAL_MONTH = "<number:month number:textual=\"true\"/>";
    public static final String LONG_TEXTUAL_MONTH = "<number:month number:style=\"long\" number:textual=\"true\"/>";
    public static final String YEAR = "<number:year/>";
    public static final String LONG_YEAR = "<number:year number:style=\"long\"/>";
    public static final String DASH = "<number:text>-</number:text>";
    public static final String COLON = "<number:text>:</number:text>";
    public static final String DOT = "<number:text>.</number:text>";
    public static final String DOT_SPACE = "<number:text>. </number:text>";
    public static final String SLASH = "<number:text>/</number:text>";
    public static final String SPACE = "<number:text> </number:text>";
    public static final String DAY_OF_WEEK = "<number:day-of-week/>";
    public static final String WEEK = "<number:week-of-year/>";
    public static final String HOURS = "<number:hours/>";
    public static final String LONG_HOURS = "<number:hours number:style=\"long\"/>";
    public static final String MINUTES = "<number:minutes/>";
    public static final String LONG_MINUTES = "<number:minutes number:style=\"long\"/>";
    public static final String SECONDS = "<number:seconds/>";
    public static final String LONG_SECONDS = "<number:seconds number:style=\"long\"/>";
    private final String[] strings;

    public static String text(String s) {
        return "<number:text>" + s + "</number:text>";
    }

    public static String longSeconds(int n) {
        return "<number:seconds number:style=\"long\" number:decimal-places=\"" + n + "\"/>";
    }

    public DateTimeStyleFormat(String ... strings) {
        this.strings = strings;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        for (String string : this.strings) {
            appendable.append(string);
        }
    }
}

