/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.util.Hidable;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

final class CoreDataStyle
implements NamedObject,
Hidable {
    private final boolean hidden;
    private final String countryCode;
    private final String languageCode;
    private final String name;
    private final boolean volatileStyle;

    CoreDataStyle(String name, boolean hidden, String languageCode, String countryCode, boolean volatileStyle) {
        this.name = name;
        this.hidden = hidden;
        this.countryCode = countryCode;
        this.languageCode = languageCode;
        this.volatileStyle = volatileStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void appendLVAttributes(XMLUtil util, Appendable appendable) throws IOException {
        this.appendLocaleAttributes(util, appendable);
        this.appendVolatileAttribute(util, appendable);
    }

    private void appendLocaleAttributes(XMLUtil util, Appendable appendable) throws IOException {
        if (this.languageCode != null) {
            util.appendEAttribute(appendable, "number:language", this.languageCode);
        }
        if (this.countryCode != null) {
            util.appendEAttribute(appendable, "number:country", this.countryCode);
        }
    }

    private void appendVolatileAttribute(XMLUtil util, Appendable appendable) throws IOException {
        if (this.volatileStyle) {
            util.appendAttribute(appendable, (CharSequence)"style:volatile", this.volatileStyle);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

