/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Paragraph;
import com.github.jferard.fastods.ParagraphElement;
import com.github.jferard.fastods.TextBuilder;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.List;

public class Text
implements ParagraphElement {
    public static final String TEXT_DATE = "<text:date/>";
    public static final String TEXT_FILE_NAME = "<text:file-name/>";
    public static final String TEXT_PAGE_COUNT = "<text:page-count>99</text:page-count>";
    public static final String TEXT_PAGE_NUMBER = "<text:page-number>1</text:page-number>";
    public static final String TEXT_SHEET_NAME = "<text:sheet-name/>";
    public static final String TEXT_TIME = "<text:time/>";
    private final List<Paragraph> paragraphs;

    public static TextBuilder builder() {
        return TextBuilder.create();
    }

    public static Text content(String text) {
        return Text.builder().parContent(text).build();
    }

    public static Text styledContent(String text, TextStyle ts) {
        return Text.builder().parStyledContent(text, ts).build();
    }

    Text(List<Paragraph> paragraphs) {
        this.paragraphs = paragraphs;
    }

    @Override
    public void addEmbeddedStylesFromCell(StylesContainer stylesContainer) {
        for (Paragraph par : this.paragraphs) {
            par.addEmbeddedStylesFromCell(stylesContainer);
        }
    }

    @Override
    public void addEmbeddedStylesFromFooterHeader(StylesContainer stylesContainer) {
        for (Paragraph par : this.paragraphs) {
            par.addEmbeddedStylesFromFooterHeader(stylesContainer);
        }
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        for (Paragraph paragraph : this.paragraphs) {
            paragraph.appendXMLContent(util, appendable);
        }
    }

    public boolean isEmpty() {
        return this.paragraphs.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        return this.paragraphs.equals(other.paragraphs);
    }

    public final int hashCode() {
        return this.paragraphs == null ? 0 : this.paragraphs.hashCode();
    }
}

