/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.BeginTableFlusher;
import com.github.jferard.fastods.EndTableFlusher;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.PreprocessedRowsFlusher;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableAppender;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.config.ConfigElement;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntrySet;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableStyle;
import com.github.jferard.fastods.util.FastFullList;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;

class TableBuilder {
    private static final int BUFFER_SIZE = 8192;
    private final int bufferSize;
    private final int columnCapacity;
    private final FastFullList<TableColumnStyle> columnStyles;
    private final ConfigItemMapEntrySet configEntry;
    private final DataStyles format;
    private final PositionUtil positionUtil;
    private final StylesContainer stylesContainer;
    private final FastFullList<TableRowImpl> tableRows;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private final boolean libreOfficeMode;
    private boolean tablePreambleWritten;
    private NamedOdsFileWriter observer;
    private int curRowIndex;
    private int lastFlushedRowIndex;
    private int lastRowIndex;
    private String name;
    private TableStyle style;

    private static void checkCol(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("Negative column number exception, column value:[" + col + "]");
        }
    }

    private static void checkRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("Negative row number exception, row value:[" + row + "]");
        }
    }

    public static TableBuilder create(PositionUtil positionUtil, WriteUtil writeUtil, XMLUtil xmlUtil, StylesContainer stylesContainer, DataStyles format, boolean libreOfficeMode, String name, int rowCapacity, int columnCapacity) {
        ConfigItemMapEntrySet configEntry = ConfigItemMapEntrySet.createSet(name);
        configEntry.add(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_MODE, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_MODE, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_POSITION, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_POSITION, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.ZOOM_TYPE, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.ZOOM_VALUE, "100"));
        configEntry.add(ConfigItem.create(ConfigElement.PAGE_VIEW_ZOOM_VALUE, "60"));
        configEntry.add(ConfigItem.create(ConfigElement.CURSOR_POSITION_X, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.CURSOR_POSITION_Y, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.ACTIVE_SPLIT_RANGE, "2"));
        configEntry.add(ConfigItem.create(ConfigElement.POSITION_LEFT, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.POSITION_RIGHT, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.POSITION_TOP, "0"));
        configEntry.add(ConfigItem.create(ConfigElement.POSITION_BOTTOM, "0"));
        return new TableBuilder(positionUtil, writeUtil, xmlUtil, stylesContainer, format, libreOfficeMode, name, rowCapacity, columnCapacity, configEntry, 8192);
    }

    TableBuilder(PositionUtil positionUtil, WriteUtil writeUtil, XMLUtil xmlUtil, StylesContainer stylesContainer, DataStyles format, boolean libreOfficeMode, String name, int rowCapacity, int columnCapacity, ConfigItemMapEntrySet configEntry, int bufferSize) {
        this.xmlUtil = xmlUtil;
        this.writeUtil = writeUtil;
        this.positionUtil = positionUtil;
        this.stylesContainer = stylesContainer;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
        this.name = name;
        this.columnCapacity = columnCapacity;
        this.configEntry = configEntry;
        this.style = TableStyle.DEFAULT_TABLE_STYLE;
        this.columnStyles = FastFullList.builder().blankElement(TableColumnStyle.DEFAULT_TABLE_COLUMN_STYLE).capacity(this.columnCapacity).build();
        this.tableRows = FastFullList.newListWithCapacity(rowCapacity);
        this.curRowIndex = -1;
        this.lastFlushedRowIndex = 0;
        this.lastRowIndex = -1;
        this.bufferSize = bufferSize;
        this.tablePreambleWritten = false;
    }

    public void addObserver(NamedOdsFileWriter observer) {
        this.observer = observer;
    }

    public void asyncFlushBeginTable(TableAppender appender) throws IOException {
        if (this.observer == null) {
            throw new IOException("Can't flush a table from an anonymous writer (there is no file)");
        }
        this.observer.update(new BeginTableFlusher(appender));
        this.tablePreambleWritten = true;
    }

    public void asyncFlushEndTable(TableAppender appender) throws IOException {
        if (!this.tablePreambleWritten) {
            this.observer.update(new BeginTableFlusher(appender));
        }
        this.observer.update(new EndTableFlusher(appender, this.tableRows.subList(this.lastFlushedRowIndex, this.tableRows.usedSize())));
    }

    public FastFullList<TableColumnStyle> getColumnStyles() {
        return this.columnStyles;
    }

    public ConfigItemMapEntry getConfigEntry() {
        return this.configEntry;
    }

    public int getRowCount() {
        return this.tableRows.usedSize();
    }

    public TableRowImpl getRow(Table table, TableAppender appender, int rowIndex) throws IOException {
        TableBuilder.checkRow(rowIndex);
        return this.getRowSecure(table, appender, rowIndex, true);
    }

    public TableRowImpl getRow(Table table, TableAppender appender, String address) throws IOException, ParseException {
        int row = this.positionUtil.newCellRef(address).getRow();
        return this.getRow(table, appender, row);
    }

    private TableRowImpl getRowSecure(Table table, TableAppender appender, int rowIndex, boolean updateRowIndex) throws IOException {
        TableRowImpl tr = this.tableRows.get(rowIndex);
        if (tr == null) {
            tr = new TableRowImpl(this.writeUtil, this.xmlUtil, this.stylesContainer, this.format, this.libreOfficeMode, table, rowIndex, this.columnCapacity);
            this.tableRows.set(rowIndex, tr);
            if (rowIndex > this.lastRowIndex) {
                this.lastRowIndex = rowIndex;
            }
            if (this.observer != null) {
                this.asyncTryToFlush(appender, rowIndex);
            }
        }
        if (updateRowIndex && this.curRowIndex < rowIndex) {
            this.curRowIndex = rowIndex;
        }
        return tr;
    }

    private void asyncTryToFlush(TableAppender appender, int rowIndex) throws IOException {
        if (this.tablePreambleWritten) {
            if (rowIndex > 0 && rowIndex % this.bufferSize == 0) {
                PreprocessedRowsFlusher preprocessedRowsFlusher = PreprocessedRowsFlusher.create(this.xmlUtil, new ArrayList<TableRowImpl>(this.tableRows.subList(this.lastFlushedRowIndex, rowIndex)));
                this.observer.update(preprocessedRowsFlusher);
                this.lastFlushedRowIndex = rowIndex;
            }
        } else {
            this.asyncFlushBeginTable(appender);
            this.tablePreambleWritten = true;
        }
    }

    public String getStyleName() {
        return this.style.getName();
    }

    public TableRowImpl nextRow(Table table, TableAppender appender) throws IOException {
        return this.getRowSecure(table, appender, this.curRowIndex + 1, true);
    }

    public void setCellMerge(Table table, TableAppender appender, int rowIndex, int colIndex, int rowCount, int colCount) throws IOException {
        TableRowImpl row = this.getRowSecure(table, appender, rowIndex, true);
        TableCell firstCell = row.getOrCreateCell(colIndex);
        if (firstCell.isCovered()) {
            throw new IllegalArgumentException("Can't merge cells from a covered cell");
        }
        firstCell.markColumnsSpanned(colCount);
        firstCell.markRowsSpanned(rowCount);
        row.coverRightCells(colIndex, colCount);
        for (int r = rowIndex + 1; r < rowIndex + rowCount; ++r) {
            TableRowImpl otherRow = this.getRowSecure(table, appender, r, false);
            otherRow.coverRightCells(colIndex - 1, colCount + 1);
        }
    }

    @Deprecated
    public void setCellMerge(Table table, TableAppender appender, String address, int rowMerge, int columnMerge) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        this.setCellMerge(table, appender, position.getRow(), position.getColumn(), rowMerge, columnMerge);
    }

    public void setColumnStyle(int col, TableColumnStyle ts) {
        TableBuilder.checkCol(col);
        ts.addToContentStyles(this.stylesContainer);
        this.columnStyles.set(col, ts);
    }

    public void setConfigItem(String name, String type, String value) {
        this.configEntry.add(new ConfigItem(name, type, value));
    }

    public void updateConfigItem(String item, String value) {
        this.configEntry.set(item, value);
    }

    public void setStyle(TableStyle style) {
        this.stylesContainer.addPageStyle(style.getPageStyle());
        this.stylesContainer.addContentStyle(style);
        this.style = style;
    }

    public void setRowsSpanned(Table table, TableAppender appender, int rowIndex, int colIndex, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can't span over a negative number of rows");
        }
        if (n <= 1) {
            return;
        }
        TableCell firstCell = this.getRowSecure(table, appender, rowIndex, false).getOrCreateCell(colIndex);
        if (firstCell.isCovered()) {
            throw new IllegalArgumentException("Can't span from a covered cell");
        }
        firstCell.markRowsSpanned(n);
        this.coverCellsBelow(table, appender, rowIndex, colIndex, n);
    }

    private void coverCellsBelow(Table table, TableAppender appender, int rowIndex, int colIndex, int n) throws IOException {
        for (int r = rowIndex + 1; r < rowIndex + n; ++r) {
            TableRowImpl row = this.getRowSecure(table, appender, r, false);
            TableCell cell = row.getOrCreateCell(colIndex);
            cell.setCovered();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTableRowsUsedSize() {
        return this.tableRows.usedSize();
    }

    public TableRowImpl getTableRow(int r) {
        return this.tableRows.get(r);
    }

    public TableCellStyle findDefaultCellStyle(int columnIndex) {
        TableCellStyle style = this.columnStyles.get(columnIndex).getDefaultCellStyle();
        if (style == null) {
            style = TableCellStyle.DEFAULT_CELL_STYLE;
        }
        return style;
    }
}

