/*
 * Decompiled with CFR 0.152.
 */
package dev.jeziellago.compose.markdowntext.plugins.syntaxhighlight;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.jeziellago.compose.markdowntext.plugins.syntaxhighlight.SyntaxHighlight;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/jeziellago/compose/markdowntext/plugins/syntaxhighlight/SyntaxHighlightDelimiterProcessor;", "Lorg/commonmark/parser/delimiter/DelimiterProcessor;", "openingCharacter", "", "closingCharacter", "minLength", "", "(CCI)V", "getClosingCharacter", "getDelimiterUse", "opener", "Lorg/commonmark/parser/delimiter/DelimiterRun;", "closer", "getMinLength", "getOpeningCharacter", "process", "", "Lorg/commonmark/node/Text;", "delimiterCount", "markdowntext_release"})
@StabilityInferred(parameters=1)
public final class SyntaxHighlightDelimiterProcessor
implements DelimiterProcessor {
    private final char openingCharacter;
    private final char closingCharacter;
    private final int minLength;
    public static final int $stable;

    public SyntaxHighlightDelimiterProcessor(char openingCharacter, char closingCharacter, int minLength) {
        this.openingCharacter = openingCharacter;
        this.closingCharacter = closingCharacter;
        this.minLength = minLength;
    }

    public char getOpeningCharacter() {
        return this.openingCharacter;
    }

    public char getClosingCharacter() {
        return this.closingCharacter;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getDelimiterUse(@NotNull DelimiterRun opener, @NotNull DelimiterRun closer) {
        Intrinsics.checkNotNullParameter((Object)opener, (String)"opener");
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        return opener.length() >= this.minLength && closer.length() >= this.minLength ? this.minLength : 0;
    }

    public void process(@NotNull Text opener, @NotNull Text closer, int delimiterCount) {
        Intrinsics.checkNotNullParameter((Object)opener, (String)"opener");
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        String string = opener.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        Node syntaxHighlight = (Node)new SyntaxHighlight(string);
        Node tmp = opener.getNext();
        while (tmp != null && tmp != closer) {
            Node next = tmp.getNext();
            syntaxHighlight.appendChild(tmp);
            tmp = next;
        }
        opener.insertAfter(syntaxHighlight);
    }
}

