/*
 * Decompiled with CFR 0.152.
 */
package com.jetradarmobile.snowfall;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.View;
import com.jetradarmobile.snowfall.DrawablesKt;
import com.jetradarmobile.snowfall.R;
import com.jetradarmobile.snowfall.Randomizer;
import com.jetradarmobile.snowfall.Snowflake;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 02\u00020\u0001:\u000201B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0014J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0014J(\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0014J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\bH\u0014J\u0006\u0010-\u001a\u00020 J\u0006\u0010.\u001a\u00020 J\b\u0010/\u001a\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetradarmobile/snowfall/SnowfallView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "snowflakeAlphaMax", "", "snowflakeAlphaMin", "snowflakeAngleMax", "snowflakeImage", "Landroid/graphics/Bitmap;", "snowflakeSizeMaxInPx", "snowflakeSizeMinInPx", "snowflakeSpeedMax", "snowflakeSpeedMin", "snowflakes", "", "Lcom/jetradarmobile/snowfall/Snowflake;", "[Lcom/jetradarmobile/snowfall/Snowflake;", "snowflakesAlreadyFalling", "", "snowflakesFadingEnabled", "snowflakesNum", "updateSnowflakesThread", "Lcom/jetradarmobile/snowfall/SnowfallView$UpdateSnowflakesThread;", "createSnowflakes", "()[Lcom/jetradarmobile/snowfall/Snowflake;", "dpToPx", "dp", "onAttachedToWindow", "", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onVisibilityChanged", "changedView", "visibility", "restartFalling", "stopFalling", "updateSnowflakes", "Companion", "UpdateSnowflakesThread", "snowfall_release"})
public final class SnowfallView
extends View {
    private final int snowflakesNum;
    private final Bitmap snowflakeImage;
    private final int snowflakeAlphaMin;
    private final int snowflakeAlphaMax;
    private final int snowflakeAngleMax;
    private final int snowflakeSizeMinInPx;
    private final int snowflakeSizeMaxInPx;
    private final int snowflakeSpeedMin;
    private final int snowflakeSpeedMax;
    private final boolean snowflakesFadingEnabled;
    private final boolean snowflakesAlreadyFalling;
    private UpdateSnowflakesThread updateSnowflakesThread;
    private Snowflake[] snowflakes;
    private static final int DEFAULT_SNOWFLAKES_NUM = 200;
    private static final int DEFAULT_SNOWFLAKE_ALPHA_MIN = 150;
    private static final int DEFAULT_SNOWFLAKE_ALPHA_MAX = 250;
    private static final int DEFAULT_SNOWFLAKE_ANGLE_MAX = 10;
    private static final int DEFAULT_SNOWFLAKE_SIZE_MIN_IN_DP = 2;
    private static final int DEFAULT_SNOWFLAKE_SIZE_MAX_IN_DP = 8;
    private static final int DEFAULT_SNOWFLAKE_SPEED_MIN = 2;
    private static final int DEFAULT_SNOWFLAKE_SPEED_MAX = 8;
    private static final boolean DEFAULT_SNOWFLAKES_FADING_ENABLED = false;
    private static final boolean DEFAULT_SNOWFLAKES_ALREADY_FALLING = false;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateSnowflakesThread = new UpdateSnowflakesThread();
    }

    protected void onDetachedFromWindow() {
        UpdateSnowflakesThread updateSnowflakesThread = this.updateSnowflakesThread;
        if (updateSnowflakesThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateSnowflakesThread");
        }
        updateSnowflakesThread.quit();
        super.onDetachedFromWindow();
    }

    private final int dpToPx(int dp) {
        float f = dp;
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.snowflakes = this.createSnowflakes();
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        if (changedView == this && visibility == 8 && this.snowflakes != null) {
            Snowflake[] $this$forEach$iv = this.snowflakes;
            boolean $i$f$forEach = false;
            Snowflake[] snowflakeArray = $this$forEach$iv;
            int n = snowflakeArray.length;
            for (int i = 0; i < n; ++i) {
                Snowflake element$iv;
                Snowflake it = element$iv = snowflakeArray[i];
                boolean bl = false;
                Snowflake.reset$snowfall_release$default(it, null, 1, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onDraw(@NotNull Canvas canvas) {
        List fallingSnowflakes;
        List list;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        boolean haveAtLeastOneVisibleSnowflake = false;
        Snowflake[] localSnowflakes = this.snowflakes;
        if (localSnowflakes != null) {
            for (Snowflake snowflake : localSnowflakes) {
                if (!snowflake.isStillFalling()) continue;
                haveAtLeastOneVisibleSnowflake = true;
                snowflake.draw(canvas);
            }
        }
        if (haveAtLeastOneVisibleSnowflake) {
            this.updateSnowflakes();
        } else {
            this.setVisibility(8);
        }
        if (this.snowflakes != null) {
            void $this$filterTo$iv$iv;
            Snowflake[] $this$filter$iv = this.snowflakes;
            boolean $i$f$filter = false;
            Snowflake[] snowflakeArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var10_17 = $this$filterTo$iv$iv;
            int n = ((void)var10_17).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var10_17[i];
                boolean bl = false;
                if (!it.isStillFalling()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = fallingSnowflakes = list;
        if (list2 != null) {
            Collection $this$filter$iv = list2;
            boolean $i$f$filter = false;
            if (!$this$filter$iv.isEmpty()) {
                Iterable $this$forEach$iv = fallingSnowflakes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Snowflake it = (Snowflake)element$iv;
                    boolean bl = false;
                    it.draw(canvas);
                }
                this.updateSnowflakes();
                return;
            }
        }
        this.setVisibility(8);
    }

    public final void stopFalling() {
        if (this.snowflakes != null) {
            Snowflake[] $this$forEach$iv = this.snowflakes;
            boolean $i$f$forEach = false;
            Snowflake[] snowflakeArray = $this$forEach$iv;
            int n = snowflakeArray.length;
            for (int i = 0; i < n; ++i) {
                Snowflake element$iv;
                Snowflake it = element$iv = snowflakeArray[i];
                boolean bl = false;
                it.setShouldRecycleFalling(false);
            }
        }
    }

    public final void restartFalling() {
        if (this.snowflakes != null) {
            Snowflake[] $this$forEach$iv = this.snowflakes;
            boolean $i$f$forEach = false;
            Snowflake[] snowflakeArray = $this$forEach$iv;
            int n = snowflakeArray.length;
            for (int i = 0; i < n; ++i) {
                Snowflake element$iv;
                Snowflake it = element$iv = snowflakeArray[i];
                boolean bl = false;
                it.setShouldRecycleFalling(true);
            }
        }
    }

    private final Snowflake[] createSnowflakes() {
        Randomizer randomizer = new Randomizer();
        Snowflake.Params snowflakeParams = new Snowflake.Params(this.getWidth(), this.getHeight(), this.snowflakeImage, this.snowflakeAlphaMin, this.snowflakeAlphaMax, this.snowflakeAngleMax, this.snowflakeSizeMinInPx, this.snowflakeSizeMaxInPx, this.snowflakeSpeedMin, this.snowflakeSpeedMax, this.snowflakesFadingEnabled, this.snowflakesAlreadyFalling);
        int n = this.snowflakesNum;
        Snowflake[] snowflakeArray = new Snowflake[n];
        int n2 = 0;
        while (n2 < n) {
            Snowflake snowflake;
            int n3 = n2;
            int n4 = n2++;
            Snowflake[] snowflakeArray2 = snowflakeArray;
            boolean bl = false;
            snowflakeArray2[n4] = snowflake = new Snowflake(randomizer, snowflakeParams);
        }
        return snowflakeArray;
    }

    private final void updateSnowflakes() {
        UpdateSnowflakesThread updateSnowflakesThread = this.updateSnowflakesThread;
        if (updateSnowflakesThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateSnowflakesThread");
        }
        updateSnowflakesThread.getHandler().post(new Runnable(this){
            final /* synthetic */ SnowfallView this$0;

            public final void run() {
                Snowflake[] localSnowflakes;
                boolean haveAtLeastOneVisibleSnowflake = false;
                Snowflake[] snowflakeArray = SnowfallView.access$getSnowflakes$p(this.this$0);
                if (snowflakeArray == null) {
                    return;
                }
                for (Snowflake snowflake : localSnowflakes = snowflakeArray) {
                    if (!snowflake.isStillFalling()) continue;
                    haveAtLeastOneVisibleSnowflake = true;
                    snowflake.update();
                }
                if (haveAtLeastOneVisibleSnowflake) {
                    this.this$0.postInvalidateOnAnimation();
                }
            }
            {
                this.this$0 = snowfallView;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnowfallView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SnowfallView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026R.styleable.SnowfallView)");
        TypedArray a = typedArray;
        try {
            this.snowflakesNum = a.getInt(R.styleable.SnowfallView_snowflakesNum, 200);
            Drawable drawable = a.getDrawable(R.styleable.SnowfallView_snowflakeImage);
            this.snowflakeImage = drawable != null ? DrawablesKt.toBitmap(drawable) : null;
            this.snowflakeAlphaMin = a.getInt(R.styleable.SnowfallView_snowflakeAlphaMin, 150);
            this.snowflakeAlphaMax = a.getInt(R.styleable.SnowfallView_snowflakeAlphaMax, 250);
            this.snowflakeAngleMax = a.getInt(R.styleable.SnowfallView_snowflakeAngleMax, 10);
            this.snowflakeSizeMinInPx = a.getDimensionPixelSize(R.styleable.SnowfallView_snowflakeSizeMin, this.dpToPx(2));
            this.snowflakeSizeMaxInPx = a.getDimensionPixelSize(R.styleable.SnowfallView_snowflakeSizeMax, this.dpToPx(8));
            this.snowflakeSpeedMin = a.getInt(R.styleable.SnowfallView_snowflakeSpeedMin, 2);
            this.snowflakeSpeedMax = a.getInt(R.styleable.SnowfallView_snowflakeSpeedMax, 8);
            this.snowflakesFadingEnabled = a.getBoolean(R.styleable.SnowfallView_snowflakesFadingEnabled, false);
            this.snowflakesAlreadyFalling = a.getBoolean(R.styleable.SnowfallView_snowflakesAlreadyFalling, false);
            this.setLayerType(2, null);
        }
        finally {
            a.recycle();
        }
    }

    public static final /* synthetic */ Snowflake[] access$getSnowflakes$p(SnowfallView $this) {
        return $this.snowflakes;
    }

    public static final /* synthetic */ void access$setSnowflakes$p(SnowfallView $this, Snowflake[] snowflakeArray) {
        $this.snowflakes = snowflakeArray;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetradarmobile/snowfall/SnowfallView$UpdateSnowflakesThread;", "Landroid/os/HandlerThread;", "()V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "snowfall_release"})
    private static final class UpdateSnowflakesThread
    extends HandlerThread {
        @NotNull
        private final Handler handler;

        @NotNull
        public final Handler getHandler() {
            return this.handler;
        }

        public UpdateSnowflakesThread() {
            super("SnowflakesComputations");
            this.start();
            this.handler = new Handler(this.getLooper());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetradarmobile/snowfall/SnowfallView$Companion;", "", "()V", "DEFAULT_SNOWFLAKES_ALREADY_FALLING", "", "DEFAULT_SNOWFLAKES_FADING_ENABLED", "DEFAULT_SNOWFLAKES_NUM", "", "DEFAULT_SNOWFLAKE_ALPHA_MAX", "DEFAULT_SNOWFLAKE_ALPHA_MIN", "DEFAULT_SNOWFLAKE_ANGLE_MAX", "DEFAULT_SNOWFLAKE_SIZE_MAX_IN_DP", "DEFAULT_SNOWFLAKE_SIZE_MIN_IN_DP", "DEFAULT_SNOWFLAKE_SPEED_MAX", "DEFAULT_SNOWFLAKE_SPEED_MIN", "snowfall_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

