/*
 * Decompiled with CFR 0.152.
 */
package com.jetradarmobile.snowfall;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.jetradarmobile.snowfall.Randomizer;
import com.jetradarmobile.snowfall.Snowflake;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001dH\u0002J\u0006\u0010!\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetradarmobile/snowfall/Snowflake;", "", "params", "Lcom/jetradarmobile/snowfall/Snowflake$Params;", "(Lcom/jetradarmobile/snowfall/Snowflake$Params;)V", "alpha", "", "bitmap", "Landroid/graphics/Bitmap;", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "paint$delegate", "Lkotlin/Lazy;", "getParams", "()Lcom/jetradarmobile/snowfall/Snowflake$Params;", "positionX", "", "positionY", "randomizer", "Lcom/jetradarmobile/snowfall/Randomizer;", "getRandomizer", "()Lcom/jetradarmobile/snowfall/Randomizer;", "randomizer$delegate", "size", "speedX", "speedY", "draw", "", "canvas", "Landroid/graphics/Canvas;", "init", "update", "Params", "snowfall_release"})
public final class Snowflake {
    private int size;
    private int alpha;
    private Bitmap bitmap;
    private double speedX;
    private double speedY;
    private double positionX;
    private double positionY;
    private final Lazy paint$delegate;
    private final Lazy randomizer$delegate;
    @NotNull
    private final Params params;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final Paint getPaint() {
        Lazy lazy = this.paint$delegate;
        Snowflake snowflake = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Paint)lazy.getValue();
    }

    private final Randomizer getRandomizer() {
        Lazy lazy = this.randomizer$delegate;
        Snowflake snowflake = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Randomizer)lazy.getValue();
    }

    private final void init() {
        this.size = this.getRandomizer().randomInt(this.params.getSizeMinInPx(), this.params.getSizeMaxInPx(), true);
        if (this.params.getImage() != null) {
            this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.params.getImage(), (int)this.size, (int)this.size, (boolean)false);
        }
        float speed = (float)(this.size - this.params.getSizeMinInPx()) / (float)(this.params.getSizeMaxInPx() - this.params.getSizeMinInPx()) * (float)(this.params.getSpeedMax() - this.params.getSpeedMin()) + (float)this.params.getSpeedMin();
        double angle = Math.toRadians(this.getRandomizer().randomDouble(this.params.getAngleMax()) * (double)this.getRandomizer().randomSignum());
        this.speedX = (double)speed * Math.sin(angle);
        this.speedY = (double)speed * Math.cos(angle);
        this.alpha = Randomizer.randomInt$default(this.getRandomizer(), this.params.getAlphaMin(), this.params.getAlphaMax(), false, 4, null);
        this.getPaint().setAlpha(this.alpha);
        this.positionX = this.getRandomizer().randomDouble(this.params.getParentWidth());
        this.positionY = this.getRandomizer().randomDouble(this.params.getParentHeight());
    }

    public final void update() {
        this.positionX += this.speedX;
        this.positionY += this.speedY;
        if (this.positionY > (double)this.params.getParentHeight()) {
            this.init();
            this.positionY = -((double)this.size);
        }
        if (this.params.getFadingEnabled()) {
            this.getPaint().setAlpha((int)((float)this.alpha * ((float)((double)this.params.getParentHeight() - this.positionY) / (float)this.params.getParentHeight())));
        }
    }

    public final void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.bitmap != null) {
            canvas.drawBitmap(this.bitmap, (float)this.positionX, (float)this.positionY, this.getPaint());
        } else {
            canvas.drawCircle((float)this.positionX, (float)this.positionY, (float)this.size, this.getPaint());
        }
    }

    @NotNull
    public final Params getParams() {
        return this.params;
    }

    public Snowflake(@NotNull Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
        this.alpha = 255;
        this.paint$delegate = LazyKt.lazy((Function0)paint.2.INSTANCE);
        this.randomizer$delegate = LazyKt.lazy((Function0)randomizer.2.INSTANCE);
        this.init();
        if (!this.params.getAlreadyFalling()) {
            this.positionY = this.positionY - (double)this.params.getParentHeight() - (double)this.size;
        }
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Snowflake.class), "paint", "getPaint()Landroid/graphics/Paint;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Snowflake.class), "randomizer", "getRandomizer()Lcom/jetradarmobile/snowfall/Randomizer;"))};
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u000fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u0083\u0001\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u00c6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u0006."}, d2={"Lcom/jetradarmobile/snowfall/Snowflake$Params;", "", "parentWidth", "", "parentHeight", "image", "Landroid/graphics/Bitmap;", "alphaMin", "alphaMax", "angleMax", "sizeMinInPx", "sizeMaxInPx", "speedMin", "speedMax", "fadingEnabled", "", "alreadyFalling", "(IILandroid/graphics/Bitmap;IIIIIIIZZ)V", "getAlphaMax", "()I", "getAlphaMin", "getAlreadyFalling", "()Z", "getAngleMax", "getFadingEnabled", "getImage", "()Landroid/graphics/Bitmap;", "getParentHeight", "getParentWidth", "getSizeMaxInPx", "getSizeMinInPx", "getSpeedMax", "getSpeedMin", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "snowfall_release"})
    public static final class Params {
        private final int parentWidth;
        private final int parentHeight;
        @Nullable
        private final Bitmap image;
        private final int alphaMin;
        private final int alphaMax;
        private final int angleMax;
        private final int sizeMinInPx;
        private final int sizeMaxInPx;
        private final int speedMin;
        private final int speedMax;
        private final boolean fadingEnabled;
        private final boolean alreadyFalling;

        public final int getParentWidth() {
            return this.parentWidth;
        }

        public final int getParentHeight() {
            return this.parentHeight;
        }

        @Nullable
        public final Bitmap getImage() {
            return this.image;
        }

        public final int getAlphaMin() {
            return this.alphaMin;
        }

        public final int getAlphaMax() {
            return this.alphaMax;
        }

        public final int getAngleMax() {
            return this.angleMax;
        }

        public final int getSizeMinInPx() {
            return this.sizeMinInPx;
        }

        public final int getSizeMaxInPx() {
            return this.sizeMaxInPx;
        }

        public final int getSpeedMin() {
            return this.speedMin;
        }

        public final int getSpeedMax() {
            return this.speedMax;
        }

        public final boolean getFadingEnabled() {
            return this.fadingEnabled;
        }

        public final boolean getAlreadyFalling() {
            return this.alreadyFalling;
        }

        public Params(int parentWidth, int parentHeight, @Nullable Bitmap image, int alphaMin, int alphaMax, int angleMax, int sizeMinInPx, int sizeMaxInPx, int speedMin, int speedMax, boolean fadingEnabled, boolean alreadyFalling) {
            this.parentWidth = parentWidth;
            this.parentHeight = parentHeight;
            this.image = image;
            this.alphaMin = alphaMin;
            this.alphaMax = alphaMax;
            this.angleMax = angleMax;
            this.sizeMinInPx = sizeMinInPx;
            this.sizeMaxInPx = sizeMaxInPx;
            this.speedMin = speedMin;
            this.speedMax = speedMax;
            this.fadingEnabled = fadingEnabled;
            this.alreadyFalling = alreadyFalling;
        }

        public final int component1() {
            return this.parentWidth;
        }

        public final int component2() {
            return this.parentHeight;
        }

        @Nullable
        public final Bitmap component3() {
            return this.image;
        }

        public final int component4() {
            return this.alphaMin;
        }

        public final int component5() {
            return this.alphaMax;
        }

        public final int component6() {
            return this.angleMax;
        }

        public final int component7() {
            return this.sizeMinInPx;
        }

        public final int component8() {
            return this.sizeMaxInPx;
        }

        public final int component9() {
            return this.speedMin;
        }

        public final int component10() {
            return this.speedMax;
        }

        public final boolean component11() {
            return this.fadingEnabled;
        }

        public final boolean component12() {
            return this.alreadyFalling;
        }

        @NotNull
        public final Params copy(int parentWidth, int parentHeight, @Nullable Bitmap image, int alphaMin, int alphaMax, int angleMax, int sizeMinInPx, int sizeMaxInPx, int speedMin, int speedMax, boolean fadingEnabled, boolean alreadyFalling) {
            return new Params(parentWidth, parentHeight, image, alphaMin, alphaMax, angleMax, sizeMinInPx, sizeMaxInPx, speedMin, speedMax, fadingEnabled, alreadyFalling);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, int n, int n2, Bitmap bitmap, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n10 & 1) != 0) {
                n = params.parentWidth;
            }
            if ((n10 & 2) != 0) {
                n2 = params.parentHeight;
            }
            if ((n10 & 4) != 0) {
                bitmap = params.image;
            }
            if ((n10 & 8) != 0) {
                n3 = params.alphaMin;
            }
            if ((n10 & 0x10) != 0) {
                n4 = params.alphaMax;
            }
            if ((n10 & 0x20) != 0) {
                n5 = params.angleMax;
            }
            if ((n10 & 0x40) != 0) {
                n6 = params.sizeMinInPx;
            }
            if ((n10 & 0x80) != 0) {
                n7 = params.sizeMaxInPx;
            }
            if ((n10 & 0x100) != 0) {
                n8 = params.speedMin;
            }
            if ((n10 & 0x200) != 0) {
                n9 = params.speedMax;
            }
            if ((n10 & 0x400) != 0) {
                bl = params.fadingEnabled;
            }
            if ((n10 & 0x800) != 0) {
                bl2 = params.alreadyFalling;
            }
            return params.copy(n, n2, bitmap, n3, n4, n5, n6, n7, n8, n9, bl, bl2);
        }

        public String toString() {
            return "Params(parentWidth=" + this.parentWidth + ", parentHeight=" + this.parentHeight + ", image=" + this.image + ", alphaMin=" + this.alphaMin + ", alphaMax=" + this.alphaMax + ", angleMax=" + this.angleMax + ", sizeMinInPx=" + this.sizeMinInPx + ", sizeMaxInPx=" + this.sizeMaxInPx + ", speedMin=" + this.speedMin + ", speedMax=" + this.speedMax + ", fadingEnabled=" + this.fadingEnabled + ", alreadyFalling=" + this.alreadyFalling + ")";
        }

        public int hashCode() {
            Bitmap bitmap = this.image;
            int n = (((((((((this.parentWidth * 31 + this.parentHeight) * 31 + (bitmap != null ? bitmap.hashCode() : 0)) * 31 + this.alphaMin) * 31 + this.alphaMax) * 31 + this.angleMax) * 31 + this.sizeMinInPx) * 31 + this.sizeMaxInPx) * 31 + this.speedMin) * 31 + this.speedMax) * 31;
            int n2 = this.fadingEnabled ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.alreadyFalling ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!(this.parentWidth == params.parentWidth) || !(this.parentHeight == params.parentHeight) || !Intrinsics.areEqual((Object)this.image, (Object)params.image) || !(this.alphaMin == params.alphaMin) || !(this.alphaMax == params.alphaMax) || !(this.angleMax == params.angleMax) || !(this.sizeMinInPx == params.sizeMinInPx) || !(this.sizeMaxInPx == params.sizeMaxInPx) || !(this.speedMin == params.speedMin) || !(this.speedMax == params.speedMax) || !(this.fadingEnabled == params.fadingEnabled) || !(this.alreadyFalling == params.alreadyFalling)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

