/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.util;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

@Deprecated
public class LogUtils {
    public static final String TAG = "CameraScan";
    private static boolean isShowLog = true;
    private static int priority = 1;
    public static final int PRINTLN = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final String STACK_TRACE_FORMAT = "%s.%s(%s:%d)";
    private static final int MIN_STACK_OFFSET = 5;
    private static final int LOG_STACK_OFFSET = 6;
    private static final char TOP_LEFT_CORNER = '\u250c';
    private static final char BOTTOM_LEFT_CORNER = '\u2514';
    private static final char MIDDLE_CORNER = '\u251c';
    private static final char HORIZONTAL_LINE = '\u2502';
    private static final String DOUBLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String SINGLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String LINE_FEED = "\n";
    private static final String SPACE = " ";
    private static final String ARROW = " \u2794 ";

    private LogUtils() {
        throw new AssertionError();
    }

    public static void setShowLog(boolean isShowLog) {
        LogUtils.isShowLog = isShowLog;
    }

    public static boolean isShowLog() {
        return isShowLog;
    }

    public static int getPriority() {
        return priority;
    }

    public static void setPriority(int priority) {
        LogUtils.priority = priority;
    }

    private static String getStackTraceMessage(Object msg, int stackOffset) {
        StackTraceElement caller = LogUtils.getStackTraceElement(stackOffset);
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        String methodStack = String.format(Locale.getDefault(), STACK_TRACE_FORMAT, callerClazzName, caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
        return TOP_BORDER + LINE_FEED + SPACE + "Thread: " + Thread.currentThread().getName() + ARROW + methodStack + LINE_FEED + MIDDLE_BORDER + LINE_FEED + SPACE + msg + LINE_FEED + BOTTOM_BORDER;
    }

    private static StackTraceElement getStackTraceElement(int n) {
        return Thread.currentThread().getStackTrace()[n];
    }

    private static String getStackTraceString(Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            t.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
        return "";
    }

    public static void v(String msg) {
        if (isShowLog && priority <= 2) {
            LogUtils.log(2, msg);
        }
    }

    public static void v(Throwable t) {
        if (isShowLog && priority <= 2) {
            LogUtils.log(2, t);
        }
    }

    public static void v(String msg, Throwable t) {
        if (isShowLog && priority <= 2) {
            LogUtils.log(2, msg, t);
        }
    }

    public static void d(String msg) {
        if (isShowLog && priority <= 3) {
            LogUtils.log(3, msg);
        }
    }

    public static void d(Throwable t) {
        if (isShowLog && priority <= 3) {
            LogUtils.log(3, t);
        }
    }

    public static void d(String msg, Throwable t) {
        if (isShowLog && priority <= 3) {
            LogUtils.log(3, msg, t);
        }
    }

    public static void i(String msg) {
        if (isShowLog && priority <= 4) {
            LogUtils.log(4, msg);
        }
    }

    public static void i(Throwable t) {
        if (isShowLog && priority <= 4) {
            LogUtils.log(4, t);
        }
    }

    public static void i(String msg, Throwable t) {
        if (isShowLog && priority <= 4) {
            LogUtils.log(4, msg, t);
        }
    }

    public static void w(String msg) {
        if (isShowLog && priority <= 5) {
            LogUtils.log(5, msg);
        }
    }

    public static void w(Throwable t) {
        if (isShowLog && priority <= 5) {
            LogUtils.log(5, t);
        }
    }

    public static void w(String msg, Throwable t) {
        if (isShowLog && priority <= 5) {
            LogUtils.log(5, msg, t);
        }
    }

    public static void e(String msg) {
        if (isShowLog && priority <= 6) {
            LogUtils.log(6, msg);
        }
    }

    public static void e(Throwable t) {
        if (isShowLog && priority <= 6) {
            LogUtils.log(6, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (isShowLog && priority <= 6) {
            LogUtils.log(6, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (isShowLog && priority <= 7) {
            LogUtils.log(7, msg);
        }
    }

    public static void wtf(Throwable t) {
        if (isShowLog && priority <= 7) {
            LogUtils.log(7, t);
        }
    }

    public static void wtf(String msg, Throwable t) {
        if (isShowLog && priority <= 7) {
            LogUtils.log(7, msg, t);
        }
    }

    private static void log(int priority, String msg) {
        Log.println((int)priority, (String)TAG, (String)LogUtils.getStackTraceMessage(msg, 6));
    }

    private static void log(int priority, Throwable t) {
        Log.println((int)priority, (String)TAG, (String)LogUtils.getStackTraceMessage(LogUtils.getStackTraceString(t), 6));
    }

    private static void log(int priority, String msg, Throwable t) {
        Log.println((int)priority, (String)TAG, (String)LogUtils.getStackTraceMessage(msg + '\n' + LogUtils.getStackTraceString(t), 6));
    }

    public static void println(String msg) {
        if (isShowLog && priority <= 1) {
            System.out.println(LogUtils.getStackTraceMessage(msg, 5));
        }
    }

    public static void println(Object obj) {
        if (isShowLog && priority <= 1) {
            System.out.println(LogUtils.getStackTraceMessage(obj, 5));
        }
    }
}

