/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.view.PreviewView;
import androidx.core.app.ComponentActivity;
import com.king.camera.scan.BaseCameraScan;
import com.king.camera.scan.CameraScan;
import com.king.camera.scan.R;
import com.king.camera.scan.analyze.Analyzer;
import com.king.camera.scan.util.PermissionUtils;

public abstract class BaseCameraScanActivity<T>
extends AppCompatActivity
implements CameraScan.OnScanResultCallback<T> {
    private static final int CAMERA_PERMISSION_REQUEST_CODE = 134;
    protected PreviewView previewView;
    protected View ivFlashlight;
    private CameraScan<T> mCameraScan;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isContentView()) {
            this.setContentView(this.getLayoutId());
        }
        this.initUI();
    }

    public void initUI() {
        this.previewView = (PreviewView)this.findViewById(this.getPreviewViewId());
        int ivFlashlightId = this.getFlashlightId();
        if (ivFlashlightId != -1 && ivFlashlightId != 0) {
            this.ivFlashlight = this.findViewById(ivFlashlightId);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setOnClickListener(v -> this.onClickFlashlight());
            }
        }
        this.mCameraScan = this.createCameraScan(this.previewView);
        this.initCameraScan(this.mCameraScan);
        this.startCamera();
    }

    public void initCameraScan(@NonNull CameraScan<T> cameraScan) {
        cameraScan.setAnalyzer(this.createAnalyzer()).bindFlashlightView(this.ivFlashlight).setOnScanResultCallback(this);
    }

    protected void onClickFlashlight() {
        this.toggleTorchState();
    }

    protected void toggleTorchState() {
        if (this.getCameraScan() != null) {
            boolean isTorch = this.getCameraScan().isTorchEnabled();
            this.getCameraScan().enableTorch(!isTorch);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setSelected(!isTorch);
            }
        }
    }

    public void startCamera() {
        if (this.mCameraScan != null) {
            if (PermissionUtils.checkPermission((Context)this, "android.permission.CAMERA")) {
                this.mCameraScan.startCamera();
            } else {
                PermissionUtils.requestPermission((Activity)this, "android.permission.CAMERA", 134);
            }
        }
    }

    private void releaseCamera() {
        if (this.mCameraScan != null) {
            this.mCameraScan.release();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 134) {
            this.requestCameraPermissionResult(permissions, grantResults);
        }
    }

    public void requestCameraPermissionResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionUtils.requestPermissionsResult("android.permission.CAMERA", permissions, grantResults)) {
            this.startCamera();
        } else {
            this.finish();
        }
    }

    protected void onDestroy() {
        this.releaseCamera();
        super.onDestroy();
    }

    public boolean isContentView() {
        return true;
    }

    public int getLayoutId() {
        return R.layout.camera_scan;
    }

    public int getPreviewViewId() {
        return R.id.previewView;
    }

    public int getFlashlightId() {
        return R.id.ivFlashlight;
    }

    public CameraScan<T> getCameraScan() {
        return this.mCameraScan;
    }

    @NonNull
    public CameraScan<T> createCameraScan(PreviewView previewView) {
        return new BaseCameraScan((ComponentActivity)this, previewView);
    }

    @Nullable
    public abstract Analyzer<T> createAnalyzer();
}

