/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;

public final class PermissionUtils {
    private PermissionUtils() {
        throw new AssertionError();
    }

    public static boolean verifyReadAndWritePermissions(@NonNull Activity activity, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            int readResult = PermissionUtils.checkPermission((Context)activity, "android.permission.READ_EXTERNAL_STORAGE");
            int writeResult = PermissionUtils.checkPermission((Context)activity, "android.permission.WRITE_EXTERNAL_STORAGE");
            if (readResult != 0 || writeResult != 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)requestCode);
                return false;
            }
        }
        return true;
    }

    public static int checkPermission(@NonNull Context context, @NonNull String permission2) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission2);
    }

    public static boolean isNotificationEnabled(Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }
}

