/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.github.jdsjlzx.progressindicator.Indicator;
import java.util.ArrayList;

public class BallScaleMultipleIndicator
extends Indicator {
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    int[] alphaInts = new int[]{255, 255, 255};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        for (int i = 0; i < 3; ++i) {
            paint.setAlpha(this.alphaInts[i]);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i], (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - circleSpacing, paint);
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        long[] delays = new long[]{0L, 200L, 400L};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            scaleAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallScaleMultipleIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallScaleMultipleIndicator.this.postInvalidate();
                }
            });
            scaleAnim.setStartDelay(delays[i]);
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 0});
            alphaAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            alphaAnim.setDuration(1000L);
            alphaAnim.setRepeatCount(-1);
            this.addUpdateListener(alphaAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallScaleMultipleIndicator.this.alphaInts[index] = (Integer)animation.getAnimatedValue();
                    BallScaleMultipleIndicator.this.postInvalidate();
                }
            });
            scaleAnim.setStartDelay(delays[i]);
            animators.add(scaleAnim);
            animators.add(alphaAnim);
        }
        return animators;
    }
}

