/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.view;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.interfaces.ILoadMoreFooter;
import com.github.jdsjlzx.progressindicator.AVLoadingIndicatorView;
import com.github.jdsjlzx.view.SimpleViewSwitcher;

public class LoadingFooter
extends RelativeLayout
implements ILoadMoreFooter {
    protected State mState = State.Normal;
    private View mLoadingView;
    private View mNetworkErrorView;
    private View mTheEndView;
    private SimpleViewSwitcher mProgressView;
    private TextView mLoadingText;
    private TextView mNoMoreText;
    private TextView mNoNetWorkText;
    private String loadingHint;
    private String noMoreHint;
    private String noNetWorkHint;
    private int style;
    private int indicatorColor;
    private int hintColor = Color.parseColor((String)"#FFB5B5B5");

    public LoadingFooter(Context context) {
        super(context);
        this.init();
    }

    public LoadingFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadingFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        LoadingFooter.inflate((Context)this.getContext(), (int)R.layout.layout_recyclerview_footer, (ViewGroup)this);
        this.setOnClickListener(null);
        this.onReset();
        this.indicatorColor = Color.parseColor((String)"#FFB5B5B5");
        this.style = 0;
    }

    public void setLoadingHint(String hint) {
        this.loadingHint = hint;
    }

    public void setNoMoreHint(String hint) {
        this.noMoreHint = hint;
    }

    public void setNoNetWorkHint(String hint) {
        this.noNetWorkHint = hint;
    }

    public void setIndicatorColor(int color2) {
        this.indicatorColor = color2;
    }

    public void setHintTextColor(int color2) {
        this.hintColor = color2;
    }

    public void setViewBackgroundColor(int color2) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
    }

    public void setProgressStyle(int style2) {
        this.style = style2;
    }

    public State getState() {
        return this.mState;
    }

    public void setState(State status) {
        this.setState(status, true);
    }

    private View initIndicatorView(int style2) {
        if (style2 == -1) {
            return new ProgressBar(this.getContext(), null, 0x1010077);
        }
        AVLoadingIndicatorView progressView = (AVLoadingIndicatorView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_indicator_view, null);
        progressView.setIndicatorId(style2);
        progressView.setIndicatorColor(this.indicatorColor);
        return progressView;
    }

    @Override
    public void onReset() {
        this.onComplete();
    }

    @Override
    public void onLoading() {
        this.setState(State.Loading);
    }

    @Override
    public void onComplete() {
        this.setState(State.Normal);
    }

    @Override
    public void onNoMore() {
        this.setState(State.NoMore);
    }

    @Override
    public View getFootView() {
        return this;
    }

    public void setState(State status, boolean showView) {
        if (this.mState == status) {
            return;
        }
        this.mState = status;
        switch (status) {
            case Normal: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) break;
                this.mNetworkErrorView.setVisibility(8);
                break;
            }
            case Loading: {
                this.setOnClickListener(null);
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mLoadingView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.loading_viewstub);
                    this.mLoadingView = viewStub.inflate();
                    this.mProgressView = (SimpleViewSwitcher)this.mLoadingView.findViewById(R.id.loading_progressbar);
                    this.mLoadingText = (TextView)this.mLoadingView.findViewById(R.id.loading_text);
                }
                this.mLoadingView.setVisibility(showView ? 0 : 8);
                this.mProgressView.setVisibility(0);
                this.mProgressView.removeAllViews();
                this.mProgressView.addView(this.initIndicatorView(this.style));
                this.mLoadingText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.loadingHint) ? this.getResources().getString(R.string.list_footer_loading) : this.loadingHint));
                this.mLoadingText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.hintColor));
                break;
            }
            case NoMore: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mTheEndView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.end_viewstub);
                    this.mTheEndView = viewStub.inflate();
                    this.mNoMoreText = (TextView)this.mTheEndView.findViewById(R.id.loading_end_text);
                } else {
                    this.mTheEndView.setVisibility(0);
                }
                this.mTheEndView.setVisibility(showView ? 0 : 8);
                this.mNoMoreText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.noMoreHint) ? this.getResources().getString(R.string.list_footer_end) : this.noMoreHint));
                this.mNoMoreText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.hintColor));
                break;
            }
            case NetWorkError: {
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.network_error_viewstub);
                    this.mNetworkErrorView = viewStub.inflate();
                    this.mNoNetWorkText = (TextView)this.mNetworkErrorView.findViewById(R.id.network_error_text);
                } else {
                    this.mNetworkErrorView.setVisibility(0);
                }
                this.mNetworkErrorView.setVisibility(showView ? 0 : 8);
                this.mNoNetWorkText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.noNetWorkHint) ? this.getResources().getString(R.string.list_footer_network_error) : this.noNetWorkHint));
                this.mNoNetWorkText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.hintColor));
                break;
            }
        }
    }

    public static enum State {
        Normal,
        NoMore,
        Loading,
        NetWorkError;

    }
}

