/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.interfaces.IRefreshHeader;
import com.github.jdsjlzx.progressindicator.AVLoadingIndicatorView;
import com.github.jdsjlzx.util.WeakHandler;
import com.github.jdsjlzx.view.SimpleViewSwitcher;
import java.util.Date;

public class ArrowRefreshHeader
extends LinearLayout
implements IRefreshHeader {
    private LinearLayout mContainer;
    private ImageView mArrowImageView;
    private SimpleViewSwitcher mProgressBar;
    private TextView mStatusTextView;
    private TextView mHeaderTimeView;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private static final int ROTATE_ANIM_DURATION = 180;
    public int mMeasuredHeight;
    private int hintColor;
    private int mState = 0;
    private WeakHandler mHandler = new WeakHandler();

    public ArrowRefreshHeader(Context context) {
        super(context);
        this.initView();
    }

    public ArrowRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setPadding(0, 0, 0, 0);
        this.mContainer = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_recyclerview_refresh_header, null);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0));
        this.setGravity(80);
        this.mArrowImageView = (ImageView)this.findViewById(R.id.listview_header_arrow);
        this.mStatusTextView = (TextView)this.findViewById(R.id.refresh_status_textview);
        this.mProgressBar = (SimpleViewSwitcher)this.findViewById(R.id.listview_header_progressbar);
        this.mProgressBar.setView(this.initIndicatorView(22));
        this.mRotateUpAnim = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateUpAnim.setDuration(180L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateDownAnim.setDuration(180L);
        this.mRotateDownAnim.setFillAfter(true);
        this.mHeaderTimeView = (TextView)this.findViewById(R.id.last_refresh_time);
        this.measure(-2, -2);
        this.mMeasuredHeight = this.getMeasuredHeight();
        this.hintColor = 0x1060000;
    }

    public void setProgressStyle(int style2) {
        if (style2 == -1) {
            ProgressBar progressBar = new ProgressBar(this.getContext(), null, 0x1010077);
            this.mProgressBar.setView((View)progressBar);
        } else {
            this.mProgressBar.setView(this.initIndicatorView(style2));
        }
    }

    private View initIndicatorView(int style2) {
        AVLoadingIndicatorView progressView = (AVLoadingIndicatorView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_indicator_view, null);
        progressView.setIndicatorId(style2);
        progressView.setIndicatorColor(-7829368);
        return progressView;
    }

    public void setIndicatorColor(int color2) {
        if (this.mProgressBar.getChildAt(0) instanceof AVLoadingIndicatorView) {
            AVLoadingIndicatorView progressView = (AVLoadingIndicatorView)this.mProgressBar.getChildAt(0);
            progressView.setIndicatorColor(color2);
        }
    }

    public void setHintTextColor(int color2) {
        this.hintColor = color2;
    }

    public void setViewBackgroundColor(int color2) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
    }

    public void setArrowImageView(int resid) {
        this.mArrowImageView.setImageResource(resid);
    }

    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        if (state == 2) {
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.setVisibility(4);
            this.mProgressBar.setVisibility(0);
            this.smoothScrollTo(this.mMeasuredHeight);
        } else if (state == 3) {
            this.mArrowImageView.setVisibility(4);
            this.mProgressBar.setVisibility(4);
        } else {
            this.mArrowImageView.setVisibility(0);
            this.mProgressBar.setVisibility(4);
        }
        this.mStatusTextView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.hintColor));
        switch (state) {
            case 0: {
                if (this.mState == 1) {
                    this.mArrowImageView.startAnimation(this.mRotateDownAnim);
                }
                if (this.mState == 2) {
                    this.mArrowImageView.clearAnimation();
                }
                this.mStatusTextView.setText(R.string.listview_header_hint_normal);
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.startAnimation(this.mRotateUpAnim);
                this.mStatusTextView.setText(R.string.listview_header_hint_release);
                break;
            }
            case 2: {
                this.mStatusTextView.setText(R.string.refreshing);
                break;
            }
            case 3: {
                this.mStatusTextView.setText(R.string.refresh_done);
                break;
            }
        }
        this.mState = state;
    }

    public int getState() {
        return this.mState;
    }

    @Override
    public void refreshComplete() {
        this.mHeaderTimeView.setText((CharSequence)this.friendlyTime(new Date()));
        this.setState(3);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ArrowRefreshHeader.this.reset();
            }
        }, 200L);
    }

    @Override
    public View getHeaderView() {
        return this;
    }

    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContainer.getLayoutParams();
        lp.height = height;
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public int getVisibleHeight() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContainer.getLayoutParams();
        return lp.height;
    }

    @Override
    public int getVisibleWidth() {
        return 0;
    }

    @Override
    public void onReset() {
        this.setState(0);
    }

    @Override
    public void onPrepare() {
        this.setState(1);
    }

    @Override
    public void onRefreshing() {
        this.setState(2);
    }

    @Override
    public void onMove(float offSet, float sumOffSet) {
        if (this.getVisibleHeight() > 0 || offSet > 0.0f) {
            this.setVisibleHeight((int)offSet + this.getVisibleHeight());
            if (this.mState <= 1) {
                if (this.getVisibleHeight() > this.mMeasuredHeight) {
                    this.onPrepare();
                } else {
                    this.onReset();
                }
            }
        }
    }

    @Override
    public boolean onRelease() {
        boolean isOnRefresh = false;
        int height = this.getVisibleHeight();
        if (height == 0) {
            isOnRefresh = false;
        }
        if (this.getVisibleHeight() > this.mMeasuredHeight && this.mState < 2) {
            this.setState(2);
            isOnRefresh = true;
        }
        if (this.mState == 2 && height > this.mMeasuredHeight) {
            this.smoothScrollTo(this.mMeasuredHeight);
        }
        if (this.mState != 2) {
            this.smoothScrollTo(0);
        }
        if (this.mState == 2) {
            int destHeight = this.mMeasuredHeight;
            this.smoothScrollTo(destHeight);
        }
        return isOnRefresh;
    }

    public void reset() {
        this.smoothScrollTo(0);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ArrowRefreshHeader.this.setState(0);
            }
        }, 500L);
    }

    private void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        animator.setDuration(300L).start();
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ArrowRefreshHeader.this.setVisibleHeight((Integer)animation.getAnimatedValue());
            }
        });
        animator.start();
    }

    public String friendlyTime(Date time) {
        int ct = (int)((System.currentTimeMillis() - time.getTime()) / 1000L);
        if (ct == 0) {
            return this.getContext().getResources().getString(R.string.text_just);
        }
        if (ct > 0 && ct < 60) {
            return ct + this.getContext().getResources().getString(R.string.text_seconds_ago);
        }
        if (ct >= 60 && ct < 3600) {
            return Math.max(ct / 60, 1) + this.getContext().getResources().getString(R.string.text_minute_ago);
        }
        if (ct >= 3600 && ct < 86400) {
            return ct / 3600 + this.getContext().getResources().getString(R.string.text_hour_ago);
        }
        if (ct >= 86400 && ct < 2592000) {
            int day = ct / 86400;
            return day + this.getContext().getResources().getString(R.string.text_day_ago);
        }
        if (ct >= 2592000 && ct < 31104000) {
            return ct / 2592000 + this.getContext().getResources().getString(R.string.text_month_ago);
        }
        return ct / 31104000 + this.getContext().getResources().getString(R.string.text_year_ago);
    }
}

