/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.ItemDecoration;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.github.jdsjlzx.recyclerview.LRecyclerView;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;

public class GridItemDecoration
extends RecyclerView.ItemDecoration {
    private int verticalSpace;
    private int horizontalSpace;
    private Paint mPaint;

    public GridItemDecoration(int horizontalSpace, int verticalSpace, int colour) {
        this.horizontalSpace = horizontalSpace;
        this.verticalSpace = verticalSpace;
        this.mPaint = new Paint();
        this.mPaint.setColor(colour);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(c, parent);
        this.drawVertical(c, parent);
    }

    private int getSpanCount(RecyclerView parent) {
        int spanCount = -1;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return spanCount;
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        LRecyclerView recyclerView = (LRecyclerView)parent;
        LRecyclerViewAdapter adapter = (LRecyclerViewAdapter)parent.getAdapter();
        for (int i = 0; i < childCount; ++i) {
            if (recyclerView.isOnTop() && (adapter.isHeader(i) || adapter.isRefreshHeader(i)) || adapter.isFooter(i)) {
                c.drawRect(0.0f, 0.0f, 0.0f, 0.0f, this.mPaint);
                continue;
            }
            View child = parent.getChildAt(i);
            int top = child.getBottom();
            int bottom = top + this.verticalSpace;
            int left = child.getLeft();
            int right = child.getRight();
            c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        LRecyclerView recyclerView = (LRecyclerView)parent;
        LRecyclerViewAdapter adapter = (LRecyclerViewAdapter)parent.getAdapter();
        for (int i = 0; i < childCount; ++i) {
            if (recyclerView.isOnTop() && (adapter.isHeader(i) || adapter.isRefreshHeader(i)) || adapter.isFooter(i)) {
                c.drawRect(0.0f, 0.0f, 0.0f, 0.0f, this.mPaint);
                continue;
            }
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getTop();
            int bottom = child.getBottom() + this.verticalSpace;
            int left = child.getRight() + params.rightMargin;
            int right = left + this.horizontalSpace;
            c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    private boolean isLastRaw(RecyclerView parent, int pos, int spanCount, int childCount) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        LRecyclerViewAdapter adapter = (LRecyclerViewAdapter)parent.getAdapter();
        if (layoutManager instanceof GridLayoutManager) {
            int leftCount = childCount - childCount % spanCount;
            if (pos - adapter.getHeaderViews().size() + 1 > leftCount) {
                return true;
            }
        }
        return false;
    }

    private boolean isLastColumn(RecyclerView parent, int pos, int spanCount) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        LRecyclerViewAdapter adapter = (LRecyclerViewAdapter)parent.getAdapter();
        return layoutManager instanceof GridLayoutManager && (pos - adapter.getHeaderViews().size()) % spanCount == 0;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int itemPosition = parent.getChildAdapterPosition(view);
        int spanCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        LRecyclerViewAdapter adapter = (LRecyclerViewAdapter)parent.getAdapter();
        if (adapter.isFooter(itemPosition) || adapter.isHeader(itemPosition) || adapter.isRefreshHeader(itemPosition)) {
            outRect.set(0, 0, 0, 0);
        } else if (!(parent.getLayoutManager() instanceof GridLayoutManager)) {
            if (itemPosition == childCount - 2 - adapter.getHeaderViews().size()) {
                outRect.set(0, 0, 0, 0);
            } else {
                outRect.set(0, 0, 0, this.verticalSpace);
            }
        } else if (this.isLastRaw(parent, itemPosition, spanCount, childCount - 2 - adapter.getHeaderViews().size())) {
            if (this.isLastColumn(parent, itemPosition, spanCount)) {
                outRect.set(0, 0, 0, this.verticalSpace);
            } else {
                outRect.set(0, 0, this.horizontalSpace, this.verticalSpace);
            }
        } else if (this.isLastColumn(parent, itemPosition, spanCount)) {
            outRect.set(0, 0, 0, this.verticalSpace);
        } else {
            outRect.set(0, 0, this.horizontalSpace, this.verticalSpace);
        }
    }

    public static class Builder {
        private Context mContext;
        private Resources mResources;
        private int mHorizontal;
        private int mVertical;
        private int mColour;

        public Builder(Context context) {
            this.mContext = context;
            this.mResources = context.getResources();
            this.mHorizontal = 0;
            this.mVertical = 0;
            this.mColour = -16777216;
        }

        public Builder setColorResource(@ColorRes int resource) {
            this.setColor(ContextCompat.getColor((Context)this.mContext, (int)resource));
            return this;
        }

        public Builder setColor(@ColorInt int color2) {
            this.mColour = color2;
            return this;
        }

        public Builder setVertical(@DimenRes int vertical) {
            this.mVertical = this.mResources.getDimensionPixelSize(vertical);
            return this;
        }

        public Builder setVertical(float mVertical) {
            this.mVertical = (int)TypedValue.applyDimension((int)0, (float)mVertical, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setHorizontal(@DimenRes int horizontal) {
            this.mHorizontal = this.mResources.getDimensionPixelSize(horizontal);
            return this;
        }

        public Builder setHorizontal(float horizontal) {
            this.mHorizontal = (int)TypedValue.applyDimension((int)0, (float)horizontal, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public GridItemDecoration build() {
            return new GridItemDecoration(this.mHorizontal, this.mVertical, this.mColour);
        }
    }
}

