/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import com.github.jdsjlzx.interfaces.BaseRefreshHeader;
import com.github.jdsjlzx.interfaces.OnLoadMoreListener;
import com.github.jdsjlzx.interfaces.OnNetWorkErrorListener;
import com.github.jdsjlzx.interfaces.OnRefreshListener;
import com.github.jdsjlzx.recyclerview.AppBarStateChangeListener;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.view.ArrowRefreshHeader;
import com.github.jdsjlzx.view.LoadingFooter;

public class LRecyclerView
extends RecyclerView {
    private boolean mPullRefreshEnabled = true;
    private boolean mLoadMoreEnabled = true;
    private boolean isPulldownToRefresh = false;
    private boolean flag = false;
    private OnRefreshListener mRefreshListener;
    private OnLoadMoreListener mLoadMoreListener;
    private LScrollListener mLScrollListener;
    private ArrowRefreshHeader mRefreshHeader;
    private View mEmptyView;
    private View mFootView;
    private int mRefreshProgressStyle = -1;
    private int mLoadingMoreProgressStyle = -1;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private float mLastY = -1.0f;
    private static final float DRAG_RATE = 2.2f;
    private LRecyclerViewAdapter mWrapAdapter;
    private boolean isNoMore = false;
    private int mRefreshHeaderHeight;
    private boolean mIsVpDragger;
    private int mTouchSlop;
    private float startY;
    private float startX;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;

    public LRecyclerView(Context context) {
        this(context, null);
    }

    public LRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext().getApplicationContext()).getScaledTouchSlop();
        if (this.mPullRefreshEnabled) {
            this.mRefreshHeader = new ArrowRefreshHeader(this.getContext().getApplicationContext());
            this.mRefreshHeader.setProgressStyle(this.mRefreshProgressStyle);
        }
        LoadingFooter footView = new LoadingFooter(this.getContext().getApplicationContext());
        footView.setProgressStyle(this.mLoadingMoreProgressStyle);
        this.mFootView = footView;
        this.mFootView.setVisibility(8);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mWrapAdapter = (LRecyclerViewAdapter)adapter;
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        if (this.flag) {
            this.mWrapAdapter.getInnerAdapter().unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mWrapAdapter.getInnerAdapter().registerAdapterDataObserver(this.mDataObserver);
        this.flag = true;
        this.mDataObserver.onChanged();
        this.mWrapAdapter.setRefreshHeader(this.mRefreshHeader);
        if (this.mLoadMoreEnabled) {
            this.mWrapAdapter.addFooterView(this.mFootView);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.startY = ev.getY();
                this.startX = ev.getX();
                this.mIsVpDragger = false;
                break;
            }
            case 2: {
                if (this.mIsVpDragger) {
                    return false;
                }
                float endY = ev.getY();
                float endX = ev.getX();
                float distanceX = Math.abs(endX - this.startX);
                float distanceY = Math.abs(endY - this.startY);
                if (!(distanceX > (float)this.mTouchSlop) || !(distanceX > distanceY)) break;
                this.mIsVpDragger = true;
                return false;
            }
            case 1: 
            case 3: {
                this.mIsVpDragger = false;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (!this.isOnTop() || !this.mPullRefreshEnabled || this.appbarState != AppBarStateChangeListener.State.EXPANDED) break;
                this.mRefreshHeader.onMove(deltaY / 2.2f);
                if (this.mRefreshHeader.getVisibleHeight() <= 0 || this.mRefreshHeader.getState() >= 2) break;
                return false;
            }
            default: {
                this.mLastY = -1.0f;
                if (!this.isOnTop() || !this.mPullRefreshEnabled || this.appbarState != AppBarStateChangeListener.State.EXPANDED || !this.mRefreshHeader.releaseAction() || this.mRefreshListener == null) break;
                this.mFootView.setVisibility(8);
                this.mRefreshListener.onRefresh();
                this.isPulldownToRefresh = true;
            }
        }
        return super.onTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public boolean isOnTop() {
        return this.mPullRefreshEnabled && this.mRefreshHeader.getParent() != null;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.mDataObserver.onChanged();
    }

    public void refreshComplete() {
        this.isNoMore = false;
        this.mRefreshHeader.refreshComplete();
        this.isPulldownToRefresh = false;
        this.setFooterViewState(LoadingFooter.State.Normal, false);
    }

    public void loadMoreComplete() {
        this.setFooterViewState(LoadingFooter.State.Normal, false);
    }

    public boolean isPulldownToRefresh() {
        return this.isPulldownToRefresh;
    }

    public void setNoMore(boolean noMore) {
        this.isNoMore = noMore;
        if (this.isNoMore) {
            this.setFooterViewState(LoadingFooter.State.NoMore, true);
        } else {
            this.setFooterViewState(LoadingFooter.State.Normal, true);
        }
    }

    private void setRefreshHeader(BaseRefreshHeader refreshHeader) {
        this.mRefreshHeader = (ArrowRefreshHeader)refreshHeader;
    }

    public void setPullRefreshEnabled(boolean enabled) {
        this.mPullRefreshEnabled = enabled;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        if (this.mWrapAdapter == null) {
            throw new NullPointerException("mWrapAdapter cannot be null, please make sure the variable mWrapAdapter have been initialized.");
        }
        this.mLoadMoreEnabled = enabled;
        if (!enabled) {
            if (this.mWrapAdapter.getFooterViewsCount() > 0) {
                this.mFootView = this.mWrapAdapter.getFooterView();
            }
            if (this.mFootView instanceof LoadingFooter && null != this.mWrapAdapter) {
                this.mWrapAdapter.removeFooterView();
            } else {
                this.mFootView.setVisibility(0);
            }
        }
    }

    public void setRefreshProgressStyle(int style) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setProgressStyle(style);
        }
    }

    public void setArrowImageView(int resId) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setArrowImageView(resId);
        }
    }

    public void setLoadingMoreProgressStyle(int style) {
        this.mLoadingMoreProgressStyle = style;
        if (this.mFootView instanceof LoadingFooter) {
            ((LoadingFooter)this.mFootView).setProgressStyle(style);
        }
    }

    private void setFooterViewState(LoadingFooter.State state, boolean isScroolUp) {
        if (this.mFootView instanceof LoadingFooter) {
            ((LoadingFooter)this.mFootView).setState(state);
        }
        if (isScroolUp) {
            this.scrollToPosition(this.mWrapAdapter.getItemCount() - 1);
        }
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setOnNetWorkErrorListener(final OnNetWorkErrorListener listener) {
        LoadingFooter loadingFooter = (LoadingFooter)this.mFootView;
        loadingFooter.setState(LoadingFooter.State.NetWorkError);
        loadingFooter.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LRecyclerView.this.setFooterViewState(LoadingFooter.State.Loading, false);
                listener.reload();
            }
        });
    }

    public void setFooterViewHint(String loading, String noMore, String noNetWork) {
        if (this.mFootView instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mFootView;
            loadingFooter.setLoadingHint(loading);
            loadingFooter.setNoMoreHint(noMore);
            loadingFooter.setNoNetWorkHint(noNetWork);
        }
    }

    public void setFooterViewColor(int indicatorColor, int hintColor, int backgroundColor) {
        if (this.mFootView instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mFootView;
            loadingFooter.setIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)indicatorColor));
            loadingFooter.setHintTextColor(hintColor);
            loadingFooter.setViewBackgroundColor(backgroundColor);
        }
    }

    public void setHeaderViewColor(int indicatorColor, int hintColor, int backgroundColor) {
        this.mRefreshHeader.setIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)indicatorColor));
        this.mRefreshHeader.setHintTextColor(hintColor);
        this.mRefreshHeader.setViewBackgroundColor(backgroundColor);
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.mPullRefreshEnabled && this.mRefreshListener != null) {
            this.mRefreshHeader.setState(2);
            this.mRefreshHeaderHeight = this.mRefreshHeader.getMeasuredHeight();
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mFootView.setVisibility(8);
            this.mRefreshListener.onRefresh();
            this.isPulldownToRefresh = true;
        }
    }

    public void forceToRefresh() {
        LoadingFooter loadingFooter;
        LoadingFooter.State state;
        if (this.mFootView instanceof LoadingFooter && (state = (loadingFooter = (LoadingFooter)this.mFootView).getState()) == LoadingFooter.State.Loading) {
            return;
        }
        if (this.mPullRefreshEnabled && this.mRefreshListener != null) {
            this.scrollToPosition(0);
            this.mRefreshHeader.setState(2);
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mFootView.setVisibility(8);
            this.mRefreshListener.onRefresh();
            this.isPulldownToRefresh = true;
        }
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        int firstVisibleItemPosition = 0;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (this.layoutManagerType == null) {
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LayoutManagerType.LinearLayout;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.GridLayout;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case LinearLayout: {
                firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case GridLayout: {
                firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case StaggeredGridLayout: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                firstVisibleItemPosition = this.findMax(this.lastPositions);
            }
        }
        this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
        this.mScrolledXDistance += dx;
        this.mScrolledYDistance += dy;
        this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
        int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
        if (this.mIsScrollDown && dy == 0) {
            this.mScrolledYDistance = 0;
        }
        if (null != this.mLScrollListener) {
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        this.currentScrollState = state;
        if (this.mLScrollListener != null) {
            this.mLScrollListener.onScrollStateChanged(state);
        }
        if (this.mLoadMoreListener != null && this.mLoadMoreEnabled && this.currentScrollState == 0) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount && !this.isNoMore && this.mRefreshHeader.getState() != 2 && this.mFootView instanceof LoadingFooter) {
                this.mFootView.setVisibility(0);
                if (((LoadingFooter)this.mFootView).getState() == LoadingFooter.State.Loading) {
                    return;
                }
                this.setFooterViewState(LoadingFooter.State.Loading, true);
                this.mLoadMoreListener.onLoadMore();
            }
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (null != this.mLScrollListener) {
            if (firstVisibleItemPosition == 0) {
                if (!this.mIsScrollDown) {
                    this.mIsScrollDown = true;
                    this.mLScrollListener.onScrollDown();
                }
            } else if (this.mDistance > 20 && this.mIsScrollDown) {
                this.mIsScrollDown = false;
                this.mLScrollListener.onScrollUp();
                this.mDistance = 0;
            } else if (this.mDistance < -20 && !this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
                this.mDistance = 0;
            }
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        LRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onScrollUp();

        public void onScrollDown();

        public void onScrolled(int var1, int var2);

        public void onScrollStateChanged(int var1);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)adapter;
                if (lRecyclerViewAdapter.getInnerAdapter() != null && LRecyclerView.this.mEmptyView != null) {
                    int count = lRecyclerViewAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LRecyclerView.this.mEmptyView.setVisibility(0);
                        LRecyclerView.this.setVisibility(8);
                    } else {
                        LRecyclerView.this.mEmptyView.setVisibility(8);
                        LRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LRecyclerView.this.mEmptyView.setVisibility(0);
                    LRecyclerView.this.setVisibility(8);
                } else {
                    LRecyclerView.this.mEmptyView.setVisibility(8);
                    LRecyclerView.this.setVisibility(0);
                }
            }
            if (LRecyclerView.this.mWrapAdapter != null) {
                LRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = LRecyclerView.this.mWrapAdapter.getHeaderViewsCount();
            LRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(fromPosition + headerViewsCountCount + 1, toPosition + headerViewsCountCount + 1 + itemCount);
        }
    }
}

