/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.progressindicator.AVLoadingIndicatorView;

public class LoadingFooter
extends RelativeLayout {
    protected State mState = State.Normal;
    private View mLoadingView;
    private View mNetworkErrorView;
    private View mTheEndView;
    private AVLoadingIndicatorView mLoadingProgress;
    private TextView mLoadingText;
    private TextView mNoMoreText;
    private TextView mNoNetWorkText;
    private String loadingHint;
    private String noMoreHint;
    private String noNetWorkHint;

    public LoadingFooter(Context context) {
        super(context);
        this.init(context);
    }

    public LoadingFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoadingFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void init(Context context) {
        LoadingFooter.inflate((Context)context, (int)R.layout.layout_recyclerview_list_footer, (ViewGroup)this);
        this.setOnClickListener(null);
        this.setState(State.Normal, true);
    }

    public void setLoadingHint(String hint) {
        this.loadingHint = hint;
    }

    public void setNoMoreHint(String hint) {
        this.noMoreHint = hint;
    }

    public void setNoNetWorkHint(String hint) {
        this.noNetWorkHint = hint;
    }

    public void setProgressStyle(int style2) {
        if (null != this.mLoadingProgress) {
            this.mLoadingProgress.setIndicatorId(style2);
        }
    }

    public State getState() {
        return this.mState;
    }

    public void setState(State status) {
        this.setState(status, true);
    }

    public void setState(State status, boolean showView) {
        if (this.mState == status) {
            return;
        }
        this.mState = status;
        switch (status) {
            case Normal: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) break;
                this.mNetworkErrorView.setVisibility(8);
                break;
            }
            case Loading: {
                this.setOnClickListener(null);
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mLoadingView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.loading_viewstub);
                    this.mLoadingView = viewStub.inflate();
                    this.mLoadingProgress = (AVLoadingIndicatorView)this.mLoadingView.findViewById(R.id.loading_progress);
                    this.mLoadingText = (TextView)this.mLoadingView.findViewById(R.id.loading_text);
                } else {
                    this.mLoadingView.setVisibility(0);
                }
                this.mLoadingView.setVisibility(showView ? 0 : 8);
                this.mLoadingProgress.setVisibility(0);
                this.mLoadingText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.loadingHint) ? this.getResources().getString(R.string.list_footer_loading) : this.loadingHint));
                break;
            }
            case NoMore: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mTheEndView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.end_viewstub);
                    this.mTheEndView = viewStub.inflate();
                    this.mNoMoreText = (TextView)this.mTheEndView.findViewById(R.id.loading_end_text);
                } else {
                    this.mTheEndView.setVisibility(0);
                }
                this.mTheEndView.setVisibility(showView ? 0 : 8);
                this.mNoMoreText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.noMoreHint) ? this.getResources().getString(R.string.list_footer_end) : this.noMoreHint));
                break;
            }
            case NetWorkError: {
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.network_error_viewstub);
                    this.mNetworkErrorView = viewStub.inflate();
                    this.mNoNetWorkText = (TextView)this.mNetworkErrorView.findViewById(R.id.network_error_text);
                } else {
                    this.mNetworkErrorView.setVisibility(0);
                }
                this.mNetworkErrorView.setVisibility(showView ? 0 : 8);
                this.mNoNetWorkText.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.noNetWorkHint) ? this.getResources().getString(R.string.list_footer_network_error) : this.noNetWorkHint));
                break;
            }
        }
    }

    public static enum State {
        Normal,
        NoMore,
        Loading,
        NetWorkError;

    }
}

