/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.github.jdsjlzx.interfaces.OnLoadMoreListener;
import com.github.jdsjlzx.recyclerview.AppBarStateChangeListener;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.recyclerview.LuRecyclerViewAdapter;
import com.github.jdsjlzx.view.LoadingFooter;

public class LuRecyclerView
extends RecyclerView {
    private boolean mLoadMoreEnabled = true;
    private boolean flag = false;
    private LScrollListener mLScrollListener;
    private OnLoadMoreListener mLoadMoreListener;
    private View mEmptyView;
    private View mFootView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private LuRecyclerViewAdapter mWrapAdapter;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;

    public LuRecyclerView(Context context) {
        this(context, null);
    }

    public LuRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LuRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LoadingFooter footView = new LoadingFooter(this.getContext().getApplicationContext());
        this.mFootView = footView;
        this.mFootView.setVisibility(8);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mWrapAdapter = (LuRecyclerViewAdapter)adapter;
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        if (this.flag) {
            this.mWrapAdapter.getInnerAdapter().unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mWrapAdapter.getInnerAdapter().registerAdapterDataObserver(this.mDataObserver);
        this.flag = true;
        this.mDataObserver.onChanged();
        if (this.mLoadMoreEnabled) {
            this.mWrapAdapter.addFooterView(this.mFootView);
        }
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        this.mLoadMoreEnabled = enabled;
        if (!enabled) {
            if (this.mWrapAdapter.getFooterViewsCount() > 0) {
                this.mFootView = this.mWrapAdapter.getFooterView();
            }
            if (this.mFootView instanceof LoadingFooter && null != this.mWrapAdapter) {
                this.mWrapAdapter.removeFooterView();
            } else {
                this.mFootView.setVisibility(0);
            }
        }
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        int firstVisibleItemPosition = 0;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (this.layoutManagerType == null) {
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LayoutManagerType.LinearLayout;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.GridLayout;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case LinearLayout: {
                firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case GridLayout: {
                firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case StaggeredGridLayout: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                firstVisibleItemPosition = this.findMax(this.lastPositions);
            }
        }
        this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
        this.mScrolledXDistance += dx;
        this.mScrolledYDistance += dy;
        this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
        int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
        if (this.mIsScrollDown && dy == 0) {
            this.mScrolledYDistance = 0;
        }
        if (null != this.mLScrollListener) {
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        int currentScrollState = state;
        if (this.mLScrollListener != null) {
            this.mLScrollListener.onScrollStateChanged(state);
        }
        if (this.mLoadMoreListener != null && this.mLoadMoreEnabled && currentScrollState == 0) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount) {
                this.mLoadMoreListener.onLoadMore();
            }
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (this.mLScrollListener != null) {
            if (firstVisibleItemPosition == 0) {
                if (!this.mIsScrollDown) {
                    this.mIsScrollDown = true;
                    this.mLScrollListener.onScrollDown();
                }
            } else if (this.mDistance > 20 && this.mIsScrollDown) {
                this.mIsScrollDown = false;
                this.mLScrollListener.onScrollUp();
                this.mDistance = 0;
            } else if (this.mDistance < -20 && !this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
                this.mDistance = 0;
            }
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p != null && p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        LuRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onScrollUp();

        public void onScrollDown();

        public void onScrolled(int var1, int var2);

        public void onScrollStateChanged(int var1);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LuRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter headerAndFooterAdapter = (LRecyclerViewAdapter)adapter;
                if (headerAndFooterAdapter.getInnerAdapter() != null && LuRecyclerView.this.mEmptyView != null) {
                    int count = headerAndFooterAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LuRecyclerView.this.mEmptyView.setVisibility(0);
                        LuRecyclerView.this.setVisibility(8);
                    } else {
                        LuRecyclerView.this.mEmptyView.setVisibility(8);
                        LuRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LuRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LuRecyclerView.this.mEmptyView.setVisibility(0);
                    LuRecyclerView.this.setVisibility(8);
                } else {
                    LuRecyclerView.this.mEmptyView.setVisibility(8);
                    LuRecyclerView.this.setVisibility(0);
                }
            }
            if (LuRecyclerView.this.mWrapAdapter != null) {
                LuRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount(), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount();
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(fromPosition + headerViewsCountCount, toPosition + headerViewsCountCount + itemCount);
        }
    }
}

