/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.util;

import android.app.Activity;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.jdsjlzx.recyclerview.LRecyclerView;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.view.LoadingFooter;

public class RecyclerViewStateUtils {
    public static void setFooterViewState(Activity instance, RecyclerView recyclerView, int pageSize, LoadingFooter.State state, View.OnClickListener errorListener) {
        if (instance == null || instance.isFinishing()) {
            return;
        }
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter == null || !(outerAdapter instanceof LRecyclerViewAdapter)) {
            return;
        }
        LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)outerAdapter;
        if (lRecyclerViewAdapter.getInnerAdapter().getItemCount() < pageSize) {
            return;
        }
        if (lRecyclerViewAdapter.getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)lRecyclerViewAdapter.getFooterView();
            footerView.setState(state);
            footerView.setVisibility(0);
            if (state == LoadingFooter.State.NetWorkError) {
                footerView.setOnClickListener(errorListener);
            } else if (state == LoadingFooter.State.TheEnd) {
                ((LRecyclerView)recyclerView).setNoMore(true);
            }
        }
        recyclerView.scrollToPosition(lRecyclerViewAdapter.getItemCount() - 1);
    }

    public static LoadingFooter.State getFooterViewState(RecyclerView recyclerView) {
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter != null && outerAdapter instanceof LRecyclerViewAdapter && ((LRecyclerViewAdapter)outerAdapter).getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)((LRecyclerViewAdapter)outerAdapter).getFooterView();
            return footerView.getState();
        }
        return LoadingFooter.State.Normal;
    }

    public static void setFooterViewState(RecyclerView recyclerView, LoadingFooter.State state) {
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter != null && outerAdapter instanceof LRecyclerViewAdapter && ((LRecyclerViewAdapter)outerAdapter).getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)((LRecyclerViewAdapter)outerAdapter).getFooterView();
            footerView.setState(state);
        }
    }
}

