/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicator;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.github.jdsjlzx.progressindicator.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallZigZagIndicator
extends BaseIndicatorController {
    float[] translateX = new float[2];
    float[] translateY = new float[2];

    @Override
    public void draw(Canvas canvas, Paint paint) {
        for (int i = 0; i < 2; ++i) {
            canvas.save();
            canvas.translate(this.translateX[i], this.translateY[i]);
            canvas.drawCircle(0.0f, 0.0f, (float)(this.getWidth() / 10), paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        float startX = this.getWidth() / 6;
        float startY = this.getWidth() / 6;
        for (int i = 0; i < 2; ++i) {
            final int index = i;
            ValueAnimator translateXAnim = ValueAnimator.ofFloat((float[])new float[]{startX, (float)this.getWidth() - startX, this.getWidth() / 2, startX});
            if (i == 1) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startX, startX, this.getWidth() / 2, (float)this.getWidth() - startX});
            }
            ValueAnimator translateYAnim = ValueAnimator.ofFloat((float[])new float[]{startY, startY, this.getHeight() / 2, startY});
            if (i == 1) {
                translateYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, (float)this.getHeight() - startY, this.getHeight() / 2, (float)this.getHeight() - startY});
            }
            translateXAnim.setDuration(1000L);
            translateXAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translateXAnim.setRepeatCount(-1);
            translateXAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallZigZagIndicator.this.translateX[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallZigZagIndicator.this.postInvalidate();
                }
            });
            translateXAnim.start();
            translateYAnim.setDuration(1000L);
            translateYAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translateYAnim.setRepeatCount(-1);
            translateYAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallZigZagIndicator.this.translateY[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallZigZagIndicator.this.postInvalidate();
                }
            });
            translateYAnim.start();
            animators.add((Animator)translateXAnim);
            animators.add((Animator)translateYAnim);
        }
        return animators;
    }
}

