/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicator;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.jdsjlzx.progressindicator.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallRotateIndicator
extends BaseIndicatorController {
    float scaleFloat = 0.5f;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 10;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x - radius * 2.0f - radius, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x + radius * 2.0f + radius, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f, 0.5f});
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallRotateIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                BallRotateIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ObjectAnimator rotateAnim = ObjectAnimator.ofFloat((Object)this.getTarget(), (String)"rotation", (float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnim.setDuration(1000L);
        rotateAnim.setRepeatCount(-1);
        rotateAnim.start();
        animators.add((Animator)scaleAnim);
        animators.add((Animator)rotateAnim);
        return animators;
    }
}

