/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicator;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.github.jdsjlzx.progressindicator.indicator.BallScaleIndicator;
import java.util.ArrayList;
import java.util.List;

public class BallScaleRippleIndicator
extends BallScaleIndicator {
    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(3.0f);
        super.draw(canvas, paint);
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        scaleAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleRippleIndicator.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                BallScaleRippleIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{0, 255});
        alphaAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        alphaAnim.setDuration(1000L);
        alphaAnim.setRepeatCount(-1);
        alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleRippleIndicator.this.alpha = (Integer)animation.getAnimatedValue();
                BallScaleRippleIndicator.this.postInvalidate();
            }
        });
        alphaAnim.start();
        animators.add((Animator)scaleAnim);
        animators.add((Animator)alphaAnim);
        return animators;
    }
}

