/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.interfaces.OnSwipeMenuItemClickListener;
import com.github.jdsjlzx.interfaces.SwipeMenuCreator;
import com.github.jdsjlzx.swipe.SwipeMenu;
import com.github.jdsjlzx.swipe.SwipeMenuLayout;
import com.github.jdsjlzx.swipe.SwipeMenuView;
import java.util.List;

public abstract class SwipeMenuAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private SwipeMenuCreator mSwipeMenuCreator;
    private OnSwipeMenuItemClickListener mSwipeMenuItemClickListener;

    public void setSwipeMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
    }

    public void setSwipeMenuItemClickListener(OnSwipeMenuItemClickListener swipeMenuItemClickListener) {
        this.mSwipeMenuItemClickListener = swipeMenuItemClickListener;
    }

    public final VH onCreateViewHolder(ViewGroup parent, int viewType) {
        Object contentView = this.onCreateContentView(parent, viewType);
        if (this.mSwipeMenuCreator != null) {
            int rightMenuCount;
            SwipeMenuLayout swipeMenuLayout = (SwipeMenuLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_recyclerview_swipe_item_default, parent, false);
            SwipeMenu swipeLeftMenu = new SwipeMenu(swipeMenuLayout, viewType);
            SwipeMenu swipeRightMenu = new SwipeMenu(swipeMenuLayout, viewType);
            this.mSwipeMenuCreator.onCreateMenu(swipeLeftMenu, swipeRightMenu, viewType);
            int leftMenuCount = swipeLeftMenu.getMenuItems().size();
            if (leftMenuCount > 0) {
                SwipeMenuView swipeLeftMenuView = (SwipeMenuView)swipeMenuLayout.findViewById(R.id.swipe_left);
                swipeLeftMenuView.bindMenu(swipeLeftMenu, 1);
                swipeLeftMenuView.bindMenuItemClickListener(this.mSwipeMenuItemClickListener, swipeMenuLayout);
            }
            if ((rightMenuCount = swipeRightMenu.getMenuItems().size()) > 0) {
                SwipeMenuView swipeRightMenuView = (SwipeMenuView)swipeMenuLayout.findViewById(R.id.swipe_right);
                swipeRightMenuView.bindMenu(swipeRightMenu, -1);
                swipeRightMenuView.bindMenuItemClickListener(this.mSwipeMenuItemClickListener, swipeMenuLayout);
            }
            if (leftMenuCount > 0 || rightMenuCount > 0) {
                ViewGroup viewGroup = (ViewGroup)swipeMenuLayout.findViewById(R.id.swipe_content);
                viewGroup.addView(contentView);
                contentView = swipeMenuLayout;
            }
        }
        return this.onCompatCreateViewHolder((View)contentView, viewType);
    }

    public final void onBindViewHolder(VH holder, int position, List<Object> payloads) {
        this.onCompatBindViewHolder(holder, position, payloads);
    }

    public void onCompatBindViewHolder(VH holder, int position, List<Object> payloads) {
        this.onBindViewHolder((RecyclerView.ViewHolder)holder, position);
    }

    public abstract View onCreateContentView(ViewGroup var1, int var2);

    public abstract VH onCompatCreateViewHolder(View var1, int var2);
}

