/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.github.jdsjlzx.interfaces.Closeable;
import com.github.jdsjlzx.interfaces.OnSwipeMenuItemClickListener;
import com.github.jdsjlzx.interfaces.SwipeMenuCreator;
import com.github.jdsjlzx.recyclerview.AppBarStateChangeListener;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.swipe.SwipeMenu;
import com.github.jdsjlzx.swipe.SwipeMenuAdapter;
import com.github.jdsjlzx.swipe.SwipeMenuLayout;
import com.github.jdsjlzx.swipe.touch.DefaultItemTouchHelper;
import com.github.jdsjlzx.swipe.touch.OnItemMoveListener;
import com.github.jdsjlzx.swipe.touch.OnItemMovementListener;
import com.github.jdsjlzx.view.ArrowRefreshHeader;
import java.util.ArrayList;

public class LRecyclerView
extends RecyclerView {
    private boolean pullRefreshEnabled = true;
    private LScrollListener mLScrollListener;
    private ArrowRefreshHeader mRefreshHeader;
    private View mEmptyView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private float mLastY = -1.0f;
    private static final float DRAG_RATE = 2.5f;
    private LRecyclerViewAdapter mWrapAdapter;
    private boolean isNoMore = false;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = -1;
    private static final int INVALID_POSITION = -1;
    private int mDownX;
    private int mDownY;
    private boolean isSwiebeEnable = true;
    protected ViewConfiguration mViewConfig;
    protected SwipeMenuLayout mOldSwipedLayout;
    protected int mOldTouchedPosition = -1;
    private SwipeMenuCreator mSwipeMenuCreator;
    private OnSwipeMenuItemClickListener mSwipeMenuItemClickListener;
    private DefaultItemTouchHelper mDefaultItemTouchHelper;
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;
    private int mRefreshHeaderHeight;
    private SwipeMenuCreator mDefaultMenuCreator = new SwipeMenuCreator(){

        @Override
        public void onCreateMenu(SwipeMenu swipeLeftMenu, SwipeMenu swipeRightMenu, int viewType) {
            if (LRecyclerView.this.mSwipeMenuCreator != null) {
                LRecyclerView.this.mSwipeMenuCreator.onCreateMenu(swipeLeftMenu, swipeRightMenu, viewType);
            }
        }
    };
    private OnSwipeMenuItemClickListener mDefaultMenuItemClickListener = new OnSwipeMenuItemClickListener(){

        @Override
        public void onItemClick(Closeable closeable, int adapterPosition, int menuPosition, int direction) {
            if (LRecyclerView.this.mSwipeMenuItemClickListener != null) {
                LRecyclerView.this.mSwipeMenuItemClickListener.onItemClick(closeable, adapterPosition, menuPosition, direction);
            }
        }
    };

    public LRecyclerView(Context context) {
        this(context, null);
    }

    public LRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mViewConfig = ViewConfiguration.get((Context)this.getContext());
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (oldAdapter != null && this.mDataObserver != null) {
            oldAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        super.setAdapter(adapter);
        adapter.registerAdapterDataObserver(this.mDataObserver);
        this.mDataObserver.onChanged();
        this.mWrapAdapter = (LRecyclerViewAdapter)this.getAdapter();
        this.mRefreshHeader = this.mWrapAdapter.getRefreshHeader();
        if (this.mWrapAdapter.getInnerAdapter() instanceof SwipeMenuAdapter) {
            SwipeMenuAdapter menuAdapter = (SwipeMenuAdapter)this.mWrapAdapter.getInnerAdapter();
            menuAdapter.setSwipeMenuCreator(this.mDefaultMenuCreator);
            menuAdapter.setSwipeMenuItemClickListener(this.mDefaultMenuItemClickListener);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.isOnTop() && this.pullRefreshEnabled && this.appbarState == AppBarStateChangeListener.State.EXPANDED) {
                    this.mRefreshHeader.onMove(deltaY / 2.5f);
                    if (this.mRefreshHeader.getVisibleHeight() > 0 && this.mRefreshHeader.getState() < 2) {
                        return false;
                    }
                }
                if (!(this.mWrapAdapter.getInnerAdapter() instanceof SwipeMenuAdapter) || this.mOldSwipedLayout == null || !this.mOldSwipedLayout.isMenuOpen()) break;
                this.mOldSwipedLayout.smoothCloseMenu();
                break;
            }
            default: {
                this.mLastY = -1.0f;
                if (!this.isOnTop() || !this.pullRefreshEnabled || this.appbarState != AppBarStateChangeListener.State.EXPANDED || !this.mRefreshHeader.releaseAction() || this.mLScrollListener == null) break;
                this.mLScrollListener.onRefresh();
            }
        }
        return super.onTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private boolean isOnTop() {
        return this.pullRefreshEnabled && this.mRefreshHeader.getParent() != null;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void refreshComplete() {
        this.mRefreshHeader.refreshComplete();
        this.setNoMore(false);
    }

    public void setNoMore(boolean noMore) {
        this.isNoMore = noMore;
    }

    public void setRefreshHeader(ArrowRefreshHeader refreshHeader) {
        this.mRefreshHeader = refreshHeader;
    }

    public void setPullRefreshEnabled(boolean enabled) {
        this.pullRefreshEnabled = enabled;
        if (this.mWrapAdapter != null) {
            this.mWrapAdapter.setPullRefreshEnabled(enabled);
        }
    }

    public void setRefreshProgressStyle(int style) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setProgressStyle(style);
        }
    }

    public void setArrowImageView(int resId) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setArrowImageView(resId);
        }
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.pullRefreshEnabled && this.mLScrollListener != null) {
            this.mRefreshHeader.setState(2);
            this.mRefreshHeaderHeight = this.mRefreshHeader.getMeasuredHeight();
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mLScrollListener.onRefresh();
        }
    }

    public void forceToRefresh() {
        if (this.pullRefreshEnabled && this.mLScrollListener != null) {
            this.mRefreshHeader.setState(2);
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mLScrollListener.onRefresh();
        }
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        if (null != this.mLScrollListener) {
            int firstVisibleItemPosition = 0;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (this.layoutManagerType == null) {
                if (layoutManager instanceof LinearLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.LinearLayout;
                } else if (layoutManager instanceof GridLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.GridLayout;
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
                } else {
                    throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
                }
            }
            switch (this.layoutManagerType) {
                case LinearLayout: {
                    firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                    break;
                }
                case GridLayout: {
                    firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                    break;
                }
                case StaggeredGridLayout: {
                    StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                    if (this.lastPositions == null) {
                        this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                    }
                    staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                    this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                    staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                    firstVisibleItemPosition = this.findMax(this.lastPositions);
                }
            }
            this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
            this.mScrolledXDistance += dx;
            this.mScrolledYDistance += dy;
            this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
            int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
            if (this.mIsScrollDown && dy == 0) {
                this.mScrolledYDistance = 0;
            }
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        this.currentScrollState = state;
        if (this.currentScrollState == 0 && this.mLScrollListener != null) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount && !this.isNoMore && !this.mIsScrollDown && this.mRefreshHeader.getState() < 2) {
                this.mLScrollListener.onBottom();
            }
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (firstVisibleItemPosition == 0) {
            if (!this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
            }
        } else if (this.mDistance > 20 && this.mIsScrollDown) {
            this.mIsScrollDown = false;
            this.mLScrollListener.onScrollUp();
            this.mDistance = 0;
        } else if (this.mDistance < -20 && !this.mIsScrollDown) {
            this.mIsScrollDown = true;
            this.mLScrollListener.onScrollDown();
            this.mDistance = 0;
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        LRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mDefaultItemTouchHelper == null) {
            this.mDefaultItemTouchHelper = new DefaultItemTouchHelper();
            this.mDefaultItemTouchHelper.attachToRecyclerView(this);
        }
    }

    public void setOnItemMoveListener(OnItemMoveListener onItemMoveListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMoveListener(onItemMoveListener);
    }

    public void setOnItemMovementListener(OnItemMovementListener onItemMovementListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMovementListener(onItemMovementListener);
    }

    public void setLongPressDragEnabled(boolean canDrag) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setLongPressDragEnabled(canDrag);
    }

    public boolean isLongPressDragEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isLongPressDragEnabled();
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.initializeItemTouchHelper();
        this.isSwiebeEnable = !canSwipe;
        this.mDefaultItemTouchHelper.setItemViewSwipeEnabled(canSwipe);
    }

    public boolean isItemViewSwipeEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isItemViewSwipeEnabled();
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startDrag(viewHolder);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startSwipe(viewHolder);
    }

    public void setSwipeMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
    }

    public void setSwipeMenuItemClickListener(OnSwipeMenuItemClickListener swipeMenuItemClickListener) {
        this.mSwipeMenuItemClickListener = swipeMenuItemClickListener;
    }

    public void openLeftMenu(int position) {
        this.openMenu(position, 1, 200);
    }

    public void openLeftMenu(int position, int duration) {
        this.openMenu(position, 1, duration);
    }

    public void openRightMenu(int position) {
        this.openMenu(position, -1, 200);
    }

    public void openRightMenu(int position, int duration) {
        this.openMenu(position, -1, duration);
    }

    public void openMenu(int position, int direction, int duration) {
        View itemView;
        RecyclerView.ViewHolder vh;
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
        if ((vh = this.findViewHolderForAdapterPosition(position)) != null && (itemView = this.getSwipeMenuView(vh.itemView)) != null && itemView instanceof SwipeMenuLayout) {
            this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
            if (direction == -1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenRightMenu(duration);
            } else if (direction == 1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenLeftMenu(duration);
            }
        }
    }

    private View getSwipeMenuView(View itemView) {
        if (itemView instanceof SwipeMenuLayout) {
            return itemView;
        }
        ArrayList<View> unvisited = new ArrayList<View>();
        unvisited.add(itemView);
        while (!unvisited.isEmpty()) {
            View child = (View)unvisited.remove(0);
            if (!(child instanceof ViewGroup)) continue;
            if (child instanceof SwipeMenuLayout) {
                return child;
            }
            ViewGroup group = (ViewGroup)child;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                unvisited.add(group.getChildAt(i));
            }
        }
        return itemView;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean isIntercepted = super.onInterceptTouchEvent(e);
        if (this.isSwiebeEnable) {
            if (e.getPointerCount() > 1) {
                return true;
            }
            int action = e.getAction();
            int x = (int)e.getX();
            int y = (int)e.getY();
            switch (action) {
                case 0: {
                    View itemView;
                    this.mDownX = x;
                    this.mDownY = y;
                    isIntercepted = false;
                    int touchingPosition = this.getChildAdapterPosition(this.findChildViewUnder(x, y));
                    if (touchingPosition != this.mOldTouchedPosition && this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
                        this.mOldSwipedLayout.smoothCloseMenu();
                        isIntercepted = true;
                    }
                    if (isIntercepted) {
                        this.mOldSwipedLayout = null;
                        this.mOldTouchedPosition = -1;
                        break;
                    }
                    RecyclerView.ViewHolder vh = this.findViewHolderForAdapterPosition(touchingPosition);
                    if (vh == null || (itemView = this.getSwipeMenuView(vh.itemView)) == null || !(itemView instanceof SwipeMenuLayout)) break;
                    this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
                    this.mOldTouchedPosition = touchingPosition;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    isIntercepted = this.handleUnDown(x, y, isIntercepted);
                }
            }
        }
        return isIntercepted;
    }

    private boolean handleUnDown(int x, int y, boolean defaultValue) {
        int disX = this.mDownX - x;
        int disY = this.mDownY - y;
        if (Math.abs(disX) > this.mViewConfig.getScaledTouchSlop()) {
            defaultValue = false;
        }
        if (Math.abs(disY) < this.mViewConfig.getScaledTouchSlop() && Math.abs(disX) < this.mViewConfig.getScaledTouchSlop()) {
            defaultValue = false;
        }
        return defaultValue;
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onRefresh();

        public void onScrollUp();

        public void onScrollDown();

        public void onBottom();

        public void onScrolled(int var1, int var2);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter headerAndFooterAdapter = (LRecyclerViewAdapter)adapter;
                if (headerAndFooterAdapter.getInnerAdapter() != null && LRecyclerView.this.mEmptyView != null) {
                    int count = headerAndFooterAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LRecyclerView.this.mEmptyView.setVisibility(0);
                        LRecyclerView.this.setVisibility(8);
                    } else {
                        LRecyclerView.this.mEmptyView.setVisibility(8);
                        LRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LRecyclerView.this.mEmptyView.setVisibility(0);
                    LRecyclerView.this.setVisibility(8);
                } else {
                    LRecyclerView.this.mEmptyView.setVisibility(8);
                    LRecyclerView.this.setVisibility(0);
                }
            }
        }
    }
}

