/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe.touch;

import android.graphics.Canvas;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import com.github.jdsjlzx.swipe.touch.OnItemMoveListener;
import com.github.jdsjlzx.swipe.touch.OnItemMovementListener;

public class DefaultItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private OnItemMovementListener onItemMovementListener;
    private OnItemMoveListener onItemMoveListener;
    private boolean isItemViewSwipeEnabled;
    private boolean isLongPressDragEnabled;

    public void setLongPressDragEnabled(boolean canDrag) {
        this.isLongPressDragEnabled = canDrag;
    }

    public boolean isLongPressDragEnabled() {
        return this.isLongPressDragEnabled;
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.isItemViewSwipeEnabled = canSwipe;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.isItemViewSwipeEnabled;
    }

    public void setOnItemMoveListener(OnItemMoveListener onItemMoveListener) {
        this.onItemMoveListener = onItemMoveListener;
    }

    public OnItemMoveListener getOnItemMoveListener() {
        return this.onItemMoveListener;
    }

    public void setOnItemMovementListener(OnItemMovementListener onItemMovementListener) {
        this.onItemMovementListener = onItemMovementListener;
    }

    public OnItemMovementListener getOnItemMovementListener() {
        return this.onItemMovementListener;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder targetViewHolder) {
        if (this.onItemMovementListener != null) {
            int dragFlags = this.onItemMovementListener.onDragFlags(recyclerView, targetViewHolder);
            int swipeFlags = this.onItemMovementListener.onSwipeFlags(recyclerView, targetViewHolder);
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            int dragFlags = 15;
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)0);
        }
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 0) {
                int dragFlags = 12;
                int swipeFlags = 3;
                return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
            }
            int dragFlags = 3;
            int swipeFlags = 12;
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        return DefaultItemTouchHelperCallback.makeMovementFlags((int)0, (int)0);
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Log.e((String)"lzx", (String)(" onChildDraw actionState " + actionState));
        if (actionState == 1) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            float alpha = 1.0f;
            if (layoutManager instanceof LinearLayoutManager) {
                int orientation = ((LinearLayoutManager)layoutManager).getOrientation();
                if (orientation == 0) {
                    alpha = 1.0f - Math.abs(dY) / (float)viewHolder.itemView.getHeight();
                } else if (orientation == 1) {
                    alpha = 1.0f - Math.abs(dX) / (float)viewHolder.itemView.getWidth();
                }
            }
            viewHolder.itemView.setAlpha(alpha);
        }
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    public boolean onMove(RecyclerView arg0, RecyclerView.ViewHolder srcHolder, RecyclerView.ViewHolder targetHolder) {
        if (srcHolder.getItemViewType() == targetHolder.getItemViewType()) {
            if (this.onItemMoveListener == null) {
                return false;
            }
            return this.onItemMoveListener.onItemMove(srcHolder.getAdapterPosition(), targetHolder.getAdapterPosition());
        }
        return false;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        if (this.onItemMoveListener != null) {
            this.onItemMoveListener.onItemDismiss(viewHolder.getAdapterPosition());
        }
    }
}

