/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicator;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.github.jdsjlzx.progressindicator.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallScaleIndicator
extends BaseIndicatorController {
    float scale = 1.0f;
    int alpha = 255;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        paint.setAlpha(this.alpha);
        canvas.scale(this.scale, this.scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        paint.setAlpha(this.alpha);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - circleSpacing, paint);
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        scaleAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleIndicator.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                BallScaleIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 0});
        alphaAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        alphaAnim.setDuration(1000L);
        alphaAnim.setRepeatCount(-1);
        alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleIndicator.this.alpha = (Integer)animation.getAnimatedValue();
                BallScaleIndicator.this.postInvalidate();
            }
        });
        alphaAnim.start();
        animators.add((Animator)scaleAnim);
        animators.add((Animator)alphaAnim);
        return animators;
    }
}

