/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.util;

import android.support.v7.widget.RecyclerView;
import android.view.View;

public class ViewUtils {
    public static View getCenterXChild(RecyclerView recyclerView) {
        int childCount = recyclerView.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = recyclerView.getChildAt(i);
                if (!ViewUtils.isChildInCenterX(recyclerView, child)) continue;
                return child;
            }
        }
        return null;
    }

    public static int getCenterXChildPosition(RecyclerView recyclerView) {
        int childCount = recyclerView.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = recyclerView.getChildAt(i);
                if (!ViewUtils.isChildInCenterX(recyclerView, child)) continue;
                return recyclerView.getChildAdapterPosition(child);
            }
        }
        return childCount;
    }

    public static View getCenterYChild(RecyclerView recyclerView) {
        int childCount = recyclerView.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = recyclerView.getChildAt(i);
                if (!ViewUtils.isChildInCenterY(recyclerView, child)) continue;
                return child;
            }
        }
        return null;
    }

    public static int getCenterYChildPosition(RecyclerView recyclerView) {
        int childCount = recyclerView.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = recyclerView.getChildAt(i);
                if (!ViewUtils.isChildInCenterY(recyclerView, child)) continue;
                return recyclerView.getChildAdapterPosition(child);
            }
        }
        return childCount;
    }

    public static boolean isChildInCenterX(RecyclerView recyclerView, View view) {
        int childCount = recyclerView.getChildCount();
        int[] lvLocationOnScreen = new int[2];
        int[] vLocationOnScreen = new int[2];
        recyclerView.getLocationOnScreen(lvLocationOnScreen);
        int middleX = lvLocationOnScreen[0] + recyclerView.getWidth() / 2;
        if (childCount > 0) {
            view.getLocationOnScreen(vLocationOnScreen);
            if (vLocationOnScreen[0] <= middleX && vLocationOnScreen[0] + view.getWidth() >= middleX) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChildInCenterY(RecyclerView recyclerView, View view) {
        int childCount = recyclerView.getChildCount();
        int[] lvLocationOnScreen = new int[2];
        int[] vLocationOnScreen = new int[2];
        recyclerView.getLocationOnScreen(lvLocationOnScreen);
        int middleY = lvLocationOnScreen[1] + recyclerView.getHeight() / 2;
        if (childCount > 0) {
            view.getLocationOnScreen(vLocationOnScreen);
            if (vLocationOnScreen[1] <= middleY && vLocationOnScreen[1] + view.getHeight() >= middleY) {
                return true;
            }
        }
        return false;
    }
}

