/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.jdsjlzx.interfaces.OnSwipeMenuItemClickListener;
import com.github.jdsjlzx.interfaces.SwipeSwitch;
import com.github.jdsjlzx.swipe.ResCompat;
import com.github.jdsjlzx.swipe.SwipeMenu;
import com.github.jdsjlzx.swipe.SwipeMenuItem;
import java.util.List;

public class SwipeMenuView
extends LinearLayout {
    private SwipeSwitch mSwipeSwitch;
    private int mAdapterPosition;
    private int mDirection;
    private OnSwipeMenuItemClickListener mItemClickListener;
    private View.OnClickListener mMenuClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SwipeMenuView.this.mItemClickListener != null && SwipeMenuView.this.mSwipeSwitch != null && SwipeMenuView.this.mSwipeSwitch.isMenuOpen()) {
                SwipeMenuView.this.mItemClickListener.onItemClick(SwipeMenuView.this.mSwipeSwitch, SwipeMenuView.this.mAdapterPosition, v.getId(), SwipeMenuView.this.mDirection);
            }
        }
    };

    public SwipeMenuView(Context context) {
        this(context, null);
    }

    public SwipeMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void bindMenu(SwipeMenu swipeMenu, int direction) {
        this.removeAllViews();
        this.mDirection = direction;
        List<SwipeMenuItem> items = swipeMenu.getMenuItems();
        int index = 0;
        for (SwipeMenuItem item : items) {
            this.addItem(item, index++);
        }
    }

    public void bindMenuItemClickListener(OnSwipeMenuItemClickListener swipeMenuItemClickListener, SwipeSwitch swipeSwitch) {
        this.mItemClickListener = swipeMenuItemClickListener;
        this.mSwipeSwitch = swipeSwitch;
    }

    public void bindAdapterPosition(int position) {
        this.mAdapterPosition = position;
    }

    private void addItem(SwipeMenuItem item, int index) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(item.getWidth(), item.getHeight());
        LinearLayout parent = new LinearLayout(this.getContext());
        parent.setId(index);
        parent.setGravity(17);
        parent.setOrientation(1);
        parent.setLayoutParams((ViewGroup.LayoutParams)params);
        ResCompat.setBackground((View)parent, item.getBackground());
        parent.setOnClickListener(this.mMenuClickListener);
        this.addView((View)parent);
        if (item.getImage() != null) {
            parent.addView((View)this.createIcon(item));
        }
        if (!TextUtils.isEmpty((CharSequence)item.getText())) {
            parent.addView((View)this.createTitle(item));
        }
    }

    private ImageView createIcon(SwipeMenuItem item) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(item.getImage());
        return imageView;
    }

    private TextView createTitle(SwipeMenuItem item) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)item.getText());
        textView.setGravity(17);
        int textSize = item.getTextSize();
        if (textSize > 0) {
            textView.setTextSize((float)textSize);
        }
        int textColor = item.getTitleColor();
        textView.setTextColor(textColor);
        return textView;
    }
}

