/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import java.lang.reflect.Method;

public class ResCompat {
    public static Drawable getDrawable(Context context, int drawableId) {
        return ResCompat.getDrawable(context, drawableId, null);
    }

    public static Drawable getDrawable(Context context, int drawableId, Resources.Theme theme) {
        Resources resources = context.getResources();
        Class<?> resourcesClass = resources.getClass();
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Method getDrawableMethod = resourcesClass.getMethod("getDrawable", Integer.TYPE, Resources.Theme.class);
                getDrawableMethod.setAccessible(true);
                return (Drawable)getDrawableMethod.invoke((Object)resources, drawableId, theme);
            }
            catch (Throwable getDrawableMethod) {}
        } else {
            try {
                Method getDrawableMethod = resourcesClass.getMethod("getDrawable", Integer.TYPE);
                getDrawableMethod.setAccessible(true);
                return (Drawable)getDrawableMethod.invoke((Object)resources, drawableId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getColor(Context context, int colorId) {
        return ResCompat.getColor(context, colorId, null);
    }

    public static int getColor(Context context, int colorId, Resources.Theme theme) {
        Resources resources = context.getResources();
        Class<?> resourcesClass = resources.getClass();
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Method getColorMethod = resourcesClass.getMethod("getColor", Integer.TYPE, Resources.Theme.class);
                getColorMethod.setAccessible(true);
                return (Integer)getColorMethod.invoke((Object)resources, colorId, theme);
            }
            catch (Throwable getColorMethod) {}
        } else {
            try {
                Method getColorMethod = resourcesClass.getMethod("getColor", Integer.TYPE);
                getColorMethod.setAccessible(true);
                return (Integer)getColorMethod.invoke((Object)resources, colorId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -16777216;
    }

    public static void setBackground(View view, int drawableId) {
        ResCompat.setBackground(view, ResCompat.getDrawable(view.getContext(), drawableId));
    }

    public static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            ResCompat.setBackground("setBackground", view, background);
        } else {
            ResCompat.setBackground("setBackgroundDrawable", view, background);
        }
    }

    public static void setBackground(String method, View view, Drawable background) {
        try {
            Method viewMethod = view.getClass().getMethod(method, Drawable.class);
            viewMethod.setAccessible(true);
            viewMethod.invoke((Object)view, background);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

