/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.TextView;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.interfaces.SwipeSwitch;
import com.github.jdsjlzx.swipe.SwipeHorizontal;
import com.github.jdsjlzx.swipe.SwipeLeftHorizontal;
import com.github.jdsjlzx.swipe.SwipeRightHorizontal;

public class SwipeMenuLayout
extends FrameLayout
implements SwipeSwitch {
    public static final int DEFAULT_SCROLLER_DURATION = 200;
    private int mLeftViewId = 0;
    private int mContentViewId = 0;
    private int mRightViewId = 0;
    private float mOpenPercent = 0.5f;
    private int mScrollerDuration = 200;
    private int mScaledTouchSlop;
    private int mLastX;
    private int mLastY;
    private int mDownX;
    private int mDownY;
    private View mContentView;
    private SwipeLeftHorizontal mSwipeLeftHorizontal;
    private SwipeRightHorizontal mSwipeRightHorizontal;
    private SwipeHorizontal mSwipeCurrentHorizontal;
    private boolean shouldResetSwipe;
    private boolean mDragging;
    private boolean swipeEnable = true;
    private OverScroller mScroller;
    private VelocityTracker mVelocityTracker;
    private int mScaledMinimumFlingVelocity;
    private int mScaledMaximumFlingVelocity;

    public SwipeMenuLayout(Context context) {
        this(context, null);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SwipeMenuLayout);
        this.mLeftViewId = typedArray.getResourceId(R.styleable.SwipeMenuLayout_leftViewId, this.mLeftViewId);
        this.mContentViewId = typedArray.getResourceId(R.styleable.SwipeMenuLayout_contentViewId, this.mContentViewId);
        this.mRightViewId = typedArray.getResourceId(R.styleable.SwipeMenuLayout_rightViewId, this.mRightViewId);
        typedArray.recycle();
        ViewConfiguration mViewConfig = ViewConfiguration.get((Context)this.getContext());
        this.mScaledTouchSlop = mViewConfig.getScaledTouchSlop();
        this.mScroller = new OverScroller(this.getContext());
        this.mScaledMinimumFlingVelocity = mViewConfig.getScaledMinimumFlingVelocity();
        this.mScaledMaximumFlingVelocity = mViewConfig.getScaledMaximumFlingVelocity();
    }

    protected void onFinishInflate() {
        View view;
        super.onFinishInflate();
        if (this.mLeftViewId != 0 && this.mSwipeLeftHorizontal == null) {
            view = this.findViewById(this.mLeftViewId);
            this.mSwipeLeftHorizontal = new SwipeLeftHorizontal(view);
        }
        if (this.mRightViewId != 0 && this.mSwipeRightHorizontal == null) {
            view = this.findViewById(this.mRightViewId);
            this.mSwipeRightHorizontal = new SwipeRightHorizontal(view);
        }
        if (this.mContentViewId != 0 && this.mContentView == null) {
            this.mContentView = this.findViewById(this.mContentViewId);
        } else {
            TextView errorView = new TextView(this.getContext());
            errorView.setClickable(true);
            errorView.setGravity(17);
            errorView.setTextSize(16.0f);
            errorView.setText((CharSequence)"You may not have set the ContentView.");
            this.mContentView = errorView;
            this.addView(this.mContentView);
        }
    }

    public void setSwipeEnable(boolean swipeEnable) {
        this.swipeEnable = swipeEnable;
    }

    public boolean isSwipeEnable() {
        return this.swipeEnable;
    }

    public void setOpenPercent(float openPercent) {
        this.mOpenPercent = openPercent;
    }

    public void setScrollerDuration(int scrollerDuration) {
        this.mScrollerDuration = scrollerDuration;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean isIntercepted = super.onInterceptTouchEvent(ev);
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mDownX = this.mLastX = (int)ev.getX();
                this.mDownY = (int)ev.getY();
                isIntercepted = false;
                break;
            }
            case 2: {
                int disX = (int)(ev.getX() - (float)this.mDownX);
                int disY = (int)(ev.getY() - (float)this.mDownY);
                isIntercepted = Math.abs(disX) > this.mScaledTouchSlop && Math.abs(disX) > Math.abs(disY);
                break;
            }
            case 1: {
                isIntercepted = false;
                if (!this.isMenuOpen() || !this.mSwipeCurrentHorizontal.isClickOnContentView(this.getWidth(), ev.getX())) break;
                this.smoothCloseMenu();
                isIntercepted = true;
                break;
            }
            case 3: {
                isIntercepted = false;
                if (this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
            }
        }
        return isIntercepted;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mLastX = (int)ev.getX();
                this.mLastY = (int)ev.getY();
                break;
            }
            case 2: {
                if (!this.isSwipeEnable()) break;
                int disX = (int)((float)this.mLastX - ev.getX());
                int disY = (int)((float)this.mLastY - ev.getY());
                if (!this.mDragging && Math.abs(disX) > this.mScaledTouchSlop && Math.abs(disX) > Math.abs(disY)) {
                    this.mDragging = true;
                }
                if (!this.mDragging) break;
                if (this.mSwipeCurrentHorizontal == null || this.shouldResetSwipe) {
                    this.mSwipeCurrentHorizontal = disX < 0 ? (this.mSwipeLeftHorizontal != null ? this.mSwipeLeftHorizontal : this.mSwipeRightHorizontal) : (this.mSwipeRightHorizontal != null ? this.mSwipeRightHorizontal : this.mSwipeLeftHorizontal);
                }
                this.scrollBy(disX, 0);
                this.mLastX = (int)ev.getX();
                this.mLastY = (int)ev.getY();
                this.shouldResetSwipe = false;
                break;
            }
            case 1: {
                int dx = (int)((float)this.mDownX - ev.getX());
                int dy = (int)((float)this.mDownY - ev.getY());
                this.mDragging = false;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mScaledMaximumFlingVelocity);
                int velocityX = (int)this.mVelocityTracker.getXVelocity();
                int velocity = Math.abs(velocityX);
                if (velocity > this.mScaledMinimumFlingVelocity) {
                    if (this.mSwipeCurrentHorizontal != null) {
                        int duration = this.getSwipeDuration(ev, velocity);
                        if (this.mSwipeCurrentHorizontal instanceof SwipeRightHorizontal) {
                            if (velocityX < 0) {
                                this.smoothOpenMenu(duration);
                            } else {
                                this.smoothCloseMenu(duration);
                            }
                        } else if (velocityX > 0) {
                            this.smoothOpenMenu(duration);
                        } else {
                            this.smoothCloseMenu(duration);
                        }
                        ViewCompat.postInvalidateOnAnimation((View)this);
                    }
                } else {
                    this.judgeOpenClose(dx, dy);
                }
                this.mVelocityTracker.clear();
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                if (!(Math.abs((float)this.mDownX - ev.getX()) > (float)this.mScaledTouchSlop) && !(Math.abs((float)this.mDownY - ev.getY()) > (float)this.mScaledTouchSlop) && !this.isMenuOpen()) break;
                ev.setAction(3);
                super.onTouchEvent(ev);
                return true;
            }
            case 3: {
                this.mDragging = false;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    break;
                }
                int dx = (int)((float)this.mDownX - ev.getX());
                int dy = (int)((float)this.mDownY - ev.getY());
                this.judgeOpenClose(dx, dy);
            }
        }
        return super.onTouchEvent(ev);
    }

    private int getSwipeDuration(MotionEvent ev, int velocity) {
        int duration;
        int sx = this.getScrollX();
        int dx = (int)(ev.getX() - (float)sx);
        int width = this.mSwipeCurrentHorizontal.getMenuWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageDelta = (float)Math.abs(dx) / (float)width;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, this.mScrollerDuration);
        return duration;
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    private void judgeOpenClose(int dx, int dy) {
        if (this.mSwipeCurrentHorizontal != null) {
            if ((float)Math.abs(this.getScrollX()) >= (float)this.mSwipeCurrentHorizontal.getMenuView().getWidth() * this.mOpenPercent) {
                if (Math.abs(dx) > this.mScaledTouchSlop || Math.abs(dy) > this.mScaledTouchSlop) {
                    if (this.isMenuOpenNotEqual()) {
                        this.smoothCloseMenu();
                    } else {
                        this.smoothOpenMenu();
                    }
                } else if (this.isMenuOpen()) {
                    this.smoothCloseMenu();
                } else {
                    this.smoothOpenMenu();
                }
            } else {
                this.smoothCloseMenu();
            }
        }
    }

    public void scrollTo(int x, int y) {
        if (this.mSwipeCurrentHorizontal == null) {
            super.scrollTo(x, y);
        } else {
            SwipeHorizontal.Checker checker = this.mSwipeCurrentHorizontal.checkXY(x, y);
            this.shouldResetSwipe = checker.shouldResetSwipe;
            if (checker.x != this.getScrollX()) {
                super.scrollTo(checker.x, checker.y);
            }
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset() && this.mSwipeCurrentHorizontal != null) {
            if (this.mSwipeCurrentHorizontal instanceof SwipeRightHorizontal) {
                this.scrollTo(Math.abs(this.mScroller.getCurrX()), 0);
                this.invalidate();
            } else {
                this.scrollTo(-Math.abs(this.mScroller.getCurrX()), 0);
                this.invalidate();
            }
        }
    }

    @Override
    public boolean isMenuOpen() {
        return this.isLeftMenuOpen() || this.isRightMenuOpen();
    }

    @Override
    public boolean isLeftMenuOpen() {
        return this.mSwipeLeftHorizontal != null && this.mSwipeLeftHorizontal.isMenuOpen(this.getScrollX());
    }

    @Override
    public boolean isRightMenuOpen() {
        return this.mSwipeRightHorizontal != null && this.mSwipeRightHorizontal.isMenuOpen(this.getScrollX());
    }

    @Override
    public boolean isMenuOpenNotEqual() {
        return this.isLeftMenuOpenNotEqual() || this.isRightMenuOpenNotEqual();
    }

    @Override
    public boolean isLeftMenuOpenNotEqual() {
        return this.mSwipeLeftHorizontal != null && this.mSwipeLeftHorizontal.isMenuOpenNotEqual(this.getScrollX());
    }

    @Override
    public boolean isRightMenuOpenNotEqual() {
        return this.mSwipeRightHorizontal != null && this.mSwipeRightHorizontal.isMenuOpenNotEqual(this.getScrollX());
    }

    @Override
    public void smoothOpenLeftMenu() {
        this.smoothOpenLeftMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothOpenLeftMenu(int duration) {
        if (this.mSwipeLeftHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeLeftHorizontal;
            this.smoothOpenMenu(duration);
        }
    }

    @Override
    public void smoothOpenRightMenu() {
        this.smoothOpenRightMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothOpenRightMenu(int duration) {
        if (this.mSwipeRightHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeRightHorizontal;
            this.smoothOpenMenu(duration);
        }
    }

    @Override
    public void smoothOpenMenu() {
        this.smoothOpenMenu(this.mScrollerDuration);
    }

    private void smoothOpenMenu(int duration) {
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoOpenMenu(this.mScroller, this.getScrollX(), duration);
            this.invalidate();
        }
    }

    @Override
    public void smoothCloseLeftMenu() {
        if (this.mSwipeLeftHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeLeftHorizontal;
            this.smoothCloseMenu();
        }
    }

    @Override
    public void smoothCloseRightMenu() {
        if (this.mSwipeRightHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeRightHorizontal;
            this.smoothCloseMenu();
        }
    }

    @Override
    public void smoothCloseMenu(int duration) {
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoCloseMenu(this.mScroller, this.getScrollX(), duration);
            this.invalidate();
        }
    }

    @Override
    public void smoothCloseMenu() {
        this.smoothCloseMenu(this.mScrollerDuration);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int menuViewWidth;
        int top;
        int parentViewWidth = ViewCompat.getMeasuredWidthAndState((View)this);
        if (this.mContentView != null) {
            int contentViewWidth = ViewCompat.getMeasuredWidthAndState((View)this.mContentView);
            int contentViewHeight = ViewCompat.getMeasuredHeightAndState((View)this.mContentView);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mContentView.getLayoutParams();
            int start = this.getPaddingLeft();
            top = this.getPaddingTop() + lp.topMargin;
            this.mContentView.layout(start, top, start + contentViewWidth, top + contentViewHeight);
        }
        if (this.mSwipeLeftHorizontal != null) {
            View leftMenu = this.mSwipeLeftHorizontal.getMenuView();
            menuViewWidth = ViewCompat.getMeasuredWidthAndState((View)leftMenu);
            int menuViewHeight = ViewCompat.getMeasuredHeightAndState((View)leftMenu);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)leftMenu.getLayoutParams();
            top = this.getPaddingTop() + lp.topMargin;
            this.mSwipeLeftHorizontal.getMenuView().layout(-menuViewWidth, top, 0, top + menuViewHeight);
        }
        if (this.mSwipeRightHorizontal != null) {
            View rightMenu = this.mSwipeRightHorizontal.getMenuView();
            menuViewWidth = ViewCompat.getMeasuredWidthAndState((View)rightMenu);
            int menuViewHeight = ViewCompat.getMeasuredHeightAndState((View)rightMenu);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)rightMenu.getLayoutParams();
            top = this.getPaddingTop() + lp.topMargin;
            this.mSwipeRightHorizontal.getMenuView().layout(parentViewWidth, top, parentViewWidth + menuViewWidth, top + menuViewHeight);
        }
    }
}

