/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import com.github.jdsjlzx.swipe.SwipeMenuItem;
import com.github.jdsjlzx.swipe.SwipeMenuLayout;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenu {
    private SwipeMenuLayout mSwipeMenuLayout;
    private int mViewType;
    private List<SwipeMenuItem> mSwipeMenuItems;

    SwipeMenu(SwipeMenuLayout swipeMenuLayout, int viewType) {
        this.mSwipeMenuLayout = swipeMenuLayout;
        this.mViewType = viewType;
        this.mSwipeMenuItems = new ArrayList<SwipeMenuItem>();
    }

    public void setOpenPercent(float openPercent) {
        openPercent = openPercent > 1.0f ? 1.0f : (openPercent < 0.0f ? 0.0f : openPercent);
        this.mSwipeMenuLayout.setOpenPercent(openPercent);
    }

    public void setScrollerDuration(int scrollerDuration) {
        this.mSwipeMenuLayout.setScrollerDuration(scrollerDuration);
    }

    public void addMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.add(item);
    }

    public void removeMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.remove(item);
    }

    public List<SwipeMenuItem> getMenuItems() {
        return this.mSwipeMenuItems;
    }

    public SwipeMenuItem getMenuItem(int index) {
        return this.mSwipeMenuItems.get(index);
    }

    public Context getContext() {
        return this.mSwipeMenuLayout.getContext();
    }

    public int getViewType() {
        return this.mViewType;
    }
}

