/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.swipe;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.github.jdsjlzx.swipe.ResCompat;

public class SwipeMenuItem {
    private Context mContext;
    private String title;
    private Drawable icon;
    private Drawable background;
    private int titleColor = -1;
    private int titleSize = -1;
    private int width = -2;
    private int height = -2;

    public SwipeMenuItem(Context context) {
        this.mContext = context;
    }

    public SwipeMenuItem setTextSize(int titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    public int getTextSize() {
        return this.titleSize;
    }

    public SwipeMenuItem setTextColor(int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public SwipeMenuItem setText(String title) {
        this.title = title;
        return this;
    }

    public SwipeMenuItem setText(int resId) {
        this.setText(this.mContext.getString(resId));
        return this;
    }

    public String getText() {
        return this.title;
    }

    public SwipeMenuItem setImage(Drawable icon) {
        this.icon = icon;
        return this;
    }

    public SwipeMenuItem setImage(int resId) {
        return this.setImage(ResCompat.getDrawable(this.mContext, resId));
    }

    public Drawable getImage() {
        return this.icon;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public SwipeMenuItem setBackgroundDrawable(Drawable background) {
        this.background = background;
        return this;
    }

    public SwipeMenuItem setBackgroundDrawable(int resId) {
        this.background = ResCompat.getDrawable(this.mContext, resId);
        return this;
    }

    public SwipeMenuItem setBackgroundColor(int color) {
        this.background = new ColorDrawable(color);
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public SwipeMenuItem setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public SwipeMenuItem setHeight(int height) {
        this.height = height;
        return this;
    }
}

