/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.progressindicator.AVLoadingIndicatorView;
import com.github.jdsjlzx.view.SimpleViewSwitcher;

public class LoadingMoreFooter
extends LinearLayout {
    private SimpleViewSwitcher progressCon;
    public static final int STATE_LOADING = 0;
    public static final int STATE_COMPLETE = 1;
    public static final int STATE_NOMORE = 2;
    private TextView mText;

    public LoadingMoreFooter(Context context) {
        super(context);
        this.initView();
    }

    public LoadingMoreFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public void initView() {
        this.setGravity(17);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.progressCon = new SimpleViewSwitcher(this.getContext());
        this.progressCon.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        AVLoadingIndicatorView progressView = new AVLoadingIndicatorView(this.getContext());
        progressView.setIndicatorColor(-4868683);
        progressView.setIndicatorId(22);
        this.progressCon.setView(progressView);
        this.addView((View)this.progressCon);
        this.mText = new TextView(this.getContext());
        this.mText.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d...");
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins((int)this.getResources().getDimension(R.dimen.textandiconmargin), 0, 0, 0);
        this.mText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.mText);
    }

    public void setProgressStyle(int style) {
        if (style == -1) {
            this.progressCon.setView((View)new ProgressBar(this.getContext(), null, 0x1010077));
        } else {
            AVLoadingIndicatorView progressView = new AVLoadingIndicatorView(this.getContext());
            progressView.setIndicatorColor(-4868683);
            progressView.setIndicatorId(style);
            this.progressCon.setView(progressView);
        }
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.progressCon.setVisibility(0);
                this.mText.setText(this.getContext().getText(R.string.listview_loading));
                this.setVisibility(0);
                break;
            }
            case 1: {
                this.mText.setText(this.getContext().getText(R.string.listview_loading));
                this.setVisibility(8);
                break;
            }
            case 2: {
                this.mText.setText(this.getContext().getText(R.string.nomore_loading));
                this.progressCon.setVisibility(8);
                this.setVisibility(0);
            }
        }
    }
}

