/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.ItemDecoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.github.jdsjlzx.ItemDecoration.DoubleHeaderAdapter;
import java.util.HashMap;
import java.util.Map;

public class DoubleHeaderDecoration
extends RecyclerView.ItemDecoration {
    private DoubleHeaderAdapter mAdapter;
    private Map<Long, RecyclerView.ViewHolder> mSubHeaderCache;
    private Map<Long, RecyclerView.ViewHolder> mHeaderCache;

    public DoubleHeaderDecoration(DoubleHeaderAdapter adapter) {
        this.mAdapter = adapter;
        this.mSubHeaderCache = new HashMap<Long, RecyclerView.ViewHolder>();
        this.mHeaderCache = new HashMap<Long, RecyclerView.ViewHolder>();
    }

    public void clearDoubleHeaderCache() {
        this.clearSubHeaderCache();
        this.clearHeaderCache();
    }

    public void clearSubHeaderCache() {
        this.mSubHeaderCache.clear();
    }

    public void clearHeaderCache() {
        this.mHeaderCache.clear();
    }

    private RecyclerView.ViewHolder getSubHeader(RecyclerView parent, int position) {
        long key = this.mAdapter.getSubHeaderId(position);
        if (this.mSubHeaderCache.containsKey(key)) {
            return this.mSubHeaderCache.get(key);
        }
        Object holder = this.mAdapter.onCreateSubHeaderHolder((ViewGroup)parent);
        View header = ((RecyclerView.ViewHolder)holder).itemView;
        this.mAdapter.onBindSubHeaderHolder(holder, position);
        this.measureView(parent, header);
        this.mSubHeaderCache.put(key, (RecyclerView.ViewHolder)holder);
        return holder;
    }

    public View findHeaderViewUnder(float x, float y) {
        for (RecyclerView.ViewHolder holder : this.mHeaderCache.values()) {
            View child = holder.itemView;
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    public View findSubHeaderViewUnder(float x, float y) {
        for (RecyclerView.ViewHolder holder : this.mSubHeaderCache.values()) {
            View child = holder.itemView;
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    private RecyclerView.ViewHolder getHeader(RecyclerView parent, int position) {
        long key = this.mAdapter.getHeaderId(position);
        if (this.mHeaderCache.containsKey(key)) {
            return this.mHeaderCache.get(key);
        }
        Object holder = this.mAdapter.onCreateHeaderHolder((ViewGroup)parent);
        View header = ((RecyclerView.ViewHolder)holder).itemView;
        this.mAdapter.onBindHeaderHolder(holder, position);
        this.measureView(parent, header);
        this.mHeaderCache.put(key, (RecyclerView.ViewHolder)holder);
        return holder;
    }

    private void measureView(RecyclerView parent, View header) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
        header.measure(childWidth, childHeight);
        header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
    }

    private boolean hasSubHeader(int position) {
        if (position == 0) {
            return true;
        }
        int previous = position - 1;
        return this.mAdapter.getSubHeaderId(position) != this.mAdapter.getSubHeaderId(previous);
    }

    private boolean hasHeader(int position) {
        if (position == 0) {
            return true;
        }
        int previous = position - 1;
        return this.mAdapter.getHeaderId(position) != this.mAdapter.getHeaderId(previous);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int headerHeight = 0;
        if (position != -1 && this.hasSubHeader(position)) {
            View header;
            if (this.hasHeader(position)) {
                header = this.getHeader((RecyclerView)parent, (int)position).itemView;
                headerHeight += header.getHeight();
            }
            header = this.getSubHeader((RecyclerView)parent, (int)position).itemView;
            headerHeight += header.getHeight();
        }
        outRect.set(0, headerHeight, 0, 0);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int count = parent.getChildCount();
        boolean headerDrawn = false;
        for (int layoutPos = 0; layoutPos < count; ++layoutPos) {
            View child = parent.getChildAt(layoutPos);
            boolean visible = this.getAnimatedTop(child) > -child.getHeight();
            int adapterPos = parent.getChildAdapterPosition(child);
            if (!visible || adapterPos == -1 || headerDrawn && !this.hasSubHeader(adapterPos)) continue;
            View header = this.getHeader((RecyclerView)parent, (int)adapterPos).itemView;
            View subHeader = this.getSubHeader((RecyclerView)parent, (int)adapterPos).itemView;
            c.save();
            int left = child.getLeft();
            int top = this.getSubHeaderTop(parent, child, header, subHeader, adapterPos, layoutPos);
            c.translate((float)left, (float)top);
            subHeader.setTranslationX((float)left);
            subHeader.setTranslationY((float)top);
            subHeader.draw(c);
            c.restore();
            if (!headerDrawn || this.hasHeader(adapterPos)) {
                c.save();
                left = child.getLeft();
                top = this.getHeaderTop(parent, child, header, subHeader, adapterPos, layoutPos);
                c.translate((float)left, (float)top);
                header.setTranslationX((float)left);
                header.setTranslationY((float)top);
                header.draw(c);
                c.restore();
            }
            headerDrawn = true;
        }
    }

    private int getSubHeaderTop(RecyclerView parent, View child, View header, View subHeader, int adapterPos, int layoutPos) {
        int top = this.getAnimatedTop(child) - subHeader.getHeight();
        if (this.isFirstValidChild(layoutPos, parent)) {
            int count = parent.getChildCount();
            long currentHeaderId = this.mAdapter.getHeaderId(adapterPos);
            long currentSubHeaderId = this.mAdapter.getSubHeaderId(adapterPos);
            for (int i = layoutPos + 1; i < count; ++i) {
                int offset;
                View next = parent.getChildAt(i);
                int adapterPosHere = parent.getChildAdapterPosition(next);
                if (adapterPosHere == -1) continue;
                long nextHeaderId = this.mAdapter.getHeaderId(adapterPosHere);
                long nextSubHeaderId = this.mAdapter.getSubHeaderId(adapterPosHere);
                if (nextSubHeaderId == currentSubHeaderId) continue;
                int headersHeight = subHeader.getHeight() + this.getSubHeader((RecyclerView)parent, (int)adapterPosHere).itemView.getHeight();
                if (nextHeaderId != currentHeaderId) {
                    headersHeight += this.getHeader((RecyclerView)parent, (int)adapterPosHere).itemView.getHeight();
                }
                if ((offset = this.getAnimatedTop(next) - headersHeight) >= header.getHeight()) break;
                return offset;
            }
        }
        return Math.max(header.getHeight(), top);
    }

    private int getHeaderTop(RecyclerView parent, View child, View header, View subHeader, int adapterPos, int layoutPos) {
        int top = this.getAnimatedTop(child) - header.getHeight() - subHeader.getHeight();
        if (this.isFirstValidChild(layoutPos, parent)) {
            int count = parent.getChildCount();
            long currentId = this.mAdapter.getHeaderId(adapterPos);
            for (int i = layoutPos + 1; i < count; ++i) {
                long nextId;
                View next = parent.getChildAt(i);
                int adapterPosHere = parent.getChildAdapterPosition(next);
                if (adapterPosHere == -1 || (nextId = this.mAdapter.getHeaderId(adapterPosHere)) == currentId) continue;
                int headersHeight = header.getHeight() + this.getHeader((RecyclerView)parent, (int)adapterPosHere).itemView.getHeight();
                int offset = this.getAnimatedTop(next) - headersHeight - subHeader.getHeight();
                if (offset >= 0) break;
                return offset;
            }
            top = Math.max(0, top);
        }
        return top;
    }

    private boolean isFirstValidChild(int layoutPos, RecyclerView parent) {
        boolean isFirstValidChild = true;
        for (int otherLayoutPos = layoutPos - 1; otherLayoutPos >= 0; --otherLayoutPos) {
            boolean visible;
            View otherChild = parent.getChildAt(otherLayoutPos);
            if (parent.getChildAdapterPosition(otherChild) == -1) continue;
            boolean bl = visible = this.getAnimatedTop(otherChild) > -otherChild.getHeight();
            if (!visible) continue;
            isFirstValidChild = false;
            break;
        }
        return isFirstValidChild;
    }

    private int getAnimatedTop(View child) {
        return child.getTop() + (int)child.getTranslationY();
    }
}

