/*
 * Decompiled with CFR 0.152.
 */
package com.cundong.recyclerview.progressindicator.indicator;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.cundong.recyclerview.progressindicator.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class LineScaleIndicator
extends BaseIndicatorController {
    public static final float SCALE = 1.0f;
    float[] scaleYFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float translateX = this.getWidth() / 11;
        float translateY = this.getHeight() / 2;
        for (int i = 0; i < 5; ++i) {
            canvas.save();
            canvas.translate((float)(2 + i * 2) * translateX - translateX / 2.0f, translateY);
            canvas.scale(1.0f, this.scaleYFloats[i]);
            RectF rectF = new RectF(-translateX / 2.0f, (float)(-this.getHeight()) / 2.5f, translateX / 2.0f, (float)this.getHeight() / 2.5f);
            canvas.drawRoundRect(rectF, 5.0f, 5.0f, paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        long[] delays = new long[]{100L, 200L, 300L, 400L, 500L};
        for (int i = 0; i < 5; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay(delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LineScaleIndicator.this.scaleYFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    LineScaleIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            animators.add((Animator)scaleAnim);
        }
        return animators;
    }
}

