/*
 * Decompiled with CFR 0.152.
 */
package com.cundong.recyclerview.progressindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.cundong.recyclerview.R;
import com.cundong.recyclerview.progressindicator.indicator.BallBeatIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallClipRotateIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallClipRotateMultipleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallClipRotatePulseIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallGridBeatIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallGridPulseIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallPulseIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallPulseRiseIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallPulseSyncIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallRotateIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallScaleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallScaleMultipleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallScaleRippleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallScaleRippleMultipleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallSpinFadeLoaderIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallTrianglePathIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallZigZagDeflectIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BallZigZagIndicator;
import com.cundong.recyclerview.progressindicator.indicator.BaseIndicatorController;
import com.cundong.recyclerview.progressindicator.indicator.CubeTransitionIndicator;
import com.cundong.recyclerview.progressindicator.indicator.LineScaleIndicator;
import com.cundong.recyclerview.progressindicator.indicator.LineScalePartyIndicator;
import com.cundong.recyclerview.progressindicator.indicator.LineScalePulseOutIndicator;
import com.cundong.recyclerview.progressindicator.indicator.LineScalePulseOutRapidIndicator;
import com.cundong.recyclerview.progressindicator.indicator.LineSpinFadeLoaderIndicator;
import com.cundong.recyclerview.progressindicator.indicator.PacmanIndicator;
import com.cundong.recyclerview.progressindicator.indicator.SemiCircleSpinIndicator;
import com.cundong.recyclerview.progressindicator.indicator.SquareSpinIndicator;
import com.cundong.recyclerview.progressindicator.indicator.TriangleSkewSpinIndicator;

public class AVLoadingIndicatorView
extends View {
    public static final int BallPulse = 0;
    public static final int BallGridPulse = 1;
    public static final int BallClipRotate = 2;
    public static final int BallClipRotatePulse = 3;
    public static final int SquareSpin = 4;
    public static final int BallClipRotateMultiple = 5;
    public static final int BallPulseRise = 6;
    public static final int BallRotate = 7;
    public static final int CubeTransition = 8;
    public static final int BallZigZag = 9;
    public static final int BallZigZagDeflect = 10;
    public static final int BallTrianglePath = 11;
    public static final int BallScale = 12;
    public static final int LineScale = 13;
    public static final int LineScaleParty = 14;
    public static final int BallScaleMultiple = 15;
    public static final int BallPulseSync = 16;
    public static final int BallBeat = 17;
    public static final int LineScalePulseOut = 18;
    public static final int LineScalePulseOutRapid = 19;
    public static final int BallScaleRipple = 20;
    public static final int BallScaleRippleMultiple = 21;
    public static final int BallSpinFadeLoader = 22;
    public static final int LineSpinFadeLoader = 23;
    public static final int TriangleSkewSpin = 24;
    public static final int Pacman = 25;
    public static final int BallGridBeat = 26;
    public static final int SemiCircleSpin = 27;
    public static final int DEFAULT_SIZE = 30;
    int mIndicatorId;
    int mIndicatorColor;
    Paint mPaint;
    BaseIndicatorController mIndicatorController;
    private boolean mHasAnimation;

    public AVLoadingIndicatorView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public AVLoadingIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public AVLoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public AVLoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.AVLoadingIndicatorView);
        this.mIndicatorId = a.getInt(R.styleable.AVLoadingIndicatorView_indicator, 0);
        this.mIndicatorColor = a.getColor(R.styleable.AVLoadingIndicatorView_indicator_color, -1);
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mIndicatorColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.applyIndicator();
    }

    public void setIndicatorId(int indicatorId) {
        this.mIndicatorId = indicatorId;
        this.applyIndicator();
    }

    public void setIndicatorColor(int color2) {
        this.mIndicatorColor = color2;
        this.mPaint.setColor(this.mIndicatorColor);
        this.invalidate();
    }

    private void applyIndicator() {
        switch (this.mIndicatorId) {
            case 0: {
                this.mIndicatorController = new BallPulseIndicator();
                break;
            }
            case 1: {
                this.mIndicatorController = new BallGridPulseIndicator();
                break;
            }
            case 2: {
                this.mIndicatorController = new BallClipRotateIndicator();
                break;
            }
            case 3: {
                this.mIndicatorController = new BallClipRotatePulseIndicator();
                break;
            }
            case 4: {
                this.mIndicatorController = new SquareSpinIndicator();
                break;
            }
            case 5: {
                this.mIndicatorController = new BallClipRotateMultipleIndicator();
                break;
            }
            case 6: {
                this.mIndicatorController = new BallPulseRiseIndicator();
                break;
            }
            case 7: {
                this.mIndicatorController = new BallRotateIndicator();
                break;
            }
            case 8: {
                this.mIndicatorController = new CubeTransitionIndicator();
                break;
            }
            case 9: {
                this.mIndicatorController = new BallZigZagIndicator();
                break;
            }
            case 10: {
                this.mIndicatorController = new BallZigZagDeflectIndicator();
                break;
            }
            case 11: {
                this.mIndicatorController = new BallTrianglePathIndicator();
                break;
            }
            case 12: {
                this.mIndicatorController = new BallScaleIndicator();
                break;
            }
            case 13: {
                this.mIndicatorController = new LineScaleIndicator();
                break;
            }
            case 14: {
                this.mIndicatorController = new LineScalePartyIndicator();
                break;
            }
            case 15: {
                this.mIndicatorController = new BallScaleMultipleIndicator();
                break;
            }
            case 16: {
                this.mIndicatorController = new BallPulseSyncIndicator();
                break;
            }
            case 17: {
                this.mIndicatorController = new BallBeatIndicator();
                break;
            }
            case 18: {
                this.mIndicatorController = new LineScalePulseOutIndicator();
                break;
            }
            case 19: {
                this.mIndicatorController = new LineScalePulseOutRapidIndicator();
                break;
            }
            case 20: {
                this.mIndicatorController = new BallScaleRippleIndicator();
                break;
            }
            case 21: {
                this.mIndicatorController = new BallScaleRippleMultipleIndicator();
                break;
            }
            case 22: {
                this.mIndicatorController = new BallSpinFadeLoaderIndicator();
                break;
            }
            case 23: {
                this.mIndicatorController = new LineSpinFadeLoaderIndicator();
                break;
            }
            case 24: {
                this.mIndicatorController = new TriangleSkewSpinIndicator();
                break;
            }
            case 25: {
                this.mIndicatorController = new PacmanIndicator();
                break;
            }
            case 26: {
                this.mIndicatorController = new BallGridBeatIndicator();
                break;
            }
            case 27: {
                this.mIndicatorController = new SemiCircleSpinIndicator();
            }
        }
        this.mIndicatorController.setTarget(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.dp2px(30), widthMeasureSpec);
        int height = this.measureDimension(this.dp2px(30), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureDimension(int defaultSize, int measureSpec) {
        int result = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(defaultSize, specSize) : defaultSize);
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawIndicator(canvas);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mHasAnimation) {
            this.mHasAnimation = true;
            this.applyAnimation();
        }
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (v == 8 || v == 4) {
                this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.END);
            } else {
                this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.START);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.CANCEL);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.START);
    }

    void drawIndicator(Canvas canvas) {
        this.mIndicatorController.draw(canvas, this.mPaint);
    }

    void applyAnimation() {
        this.mIndicatorController.initAnimation();
    }

    private int dp2px(int dpValue) {
        return (int)this.getContext().getResources().getDisplayMetrics().density * dpValue;
    }

    public static @interface Indicator {
    }
}

