/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.Converter", generator="Immutables")
@Immutable
public final class ImmutableConverter
implements Plugin.Converter {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;
    private final Class cls;

    private ImmutableConverter(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction, Class cls) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
        this.cls = cls;
    }

    @Override
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public Class getCls() {
        return this.cls;
    }

    public final ImmutableConverter withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableConverter(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction, this.cls);
    }

    public final ImmutableConverter withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction, this.cls);
    }

    public final ImmutableConverter withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value, this.cls);
    }

    public final ImmutableConverter withCls(Class value) {
        if (this.cls == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "cls");
        return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConverter && this.equalTo((ImmutableConverter)another);
    }

    private boolean equalTo(ImmutableConverter another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction) && this.cls.equals(another.cls);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.warning);
        h2 += (h2 << 5) + Objects.hashCode(this.tip);
        h2 += (h2 << 5) + Objects.hashCode(this.important);
        h2 += (h2 << 5) + Objects.hashCode(this.danger);
        h2 += (h2 << 5) + Objects.hashCode(this.note);
        h2 += (h2 << 5) + Objects.hashCode(this.title);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + Objects.hashCode(this.icon);
        h2 += (h2 << 5) + Objects.hashCode(this.introduction);
        h2 += (h2 << 5) + this.cls.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Converter").omitNullValues().add("warning", this.warning).add("tip", this.tip).add("important", this.important).add("danger", this.danger).add("note", this.note).add("title", this.title).add("description", this.description).add("icon", this.icon).add("introduction", this.introduction).add("cls", this.cls).toString();
    }

    public static ImmutableConverter copyOf(Plugin.Converter instance) {
        if (instance instanceof ImmutableConverter) {
            return (ImmutableConverter)instance;
        }
        return ImmutableConverter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.Converter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLS = 1L;
        private long initBits = 1L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;
        @Nullable
        private Class cls;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Converter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Notes instance;
            if (object instanceof Notes) {
                String introductionValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String descriptionValue;
                String warningValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
            if (object instanceof Plugin.Converter) {
                instance = (Plugin.Converter)object;
                this.cls(instance.getCls());
            }
        }

        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cls(Class cls) {
            this.cls = Objects.requireNonNull(cls, "cls");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConverter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConverter(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cls");
            }
            return "Cannot build Converter, some of required attributes are not set " + attributes;
        }
    }
}

