/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableSet;

public class SchemaBuilders {
    public static SchemaBuilder of(Schema schema, String ... excludeFields) {
        return SchemaBuilders.of(schema, Arrays.asList(excludeFields));
    }

    public static SchemaBuilder of(Schema schema, Collection<String> excludeFields) {
        ImmutableSet<Object> exclude;
        ImmutableSet<Object> immutableSet = exclude = null != excludeFields ? ImmutableSet.copyOf(excludeFields) : ImmutableSet.of();
        SchemaBuilder builder = Schema.Type.ARRAY == schema.type() ? SchemaBuilder.array((Schema)schema.valueSchema()) : (Schema.Type.MAP == schema.type() ? SchemaBuilder.map((Schema)schema.keySchema(), (Schema)schema.valueSchema()) : SchemaBuilder.type((Schema.Type)schema.type()));
        if (schema.isOptional()) {
            builder.optional();
        }
        if (!Strings.isNullOrEmpty(schema.name())) {
            builder.name(schema.name());
        }
        if (!Strings.isNullOrEmpty(schema.doc())) {
            builder.doc(schema.doc());
        }
        builder.version(schema.version());
        if (null != schema.parameters()) {
            builder.parameters(schema.parameters());
        }
        if (Schema.Type.STRUCT == schema.type()) {
            schema.fields().stream().filter(field -> !exclude.contains(field.name())).forEach(field -> builder.field(field.name(), field.schema()));
        }
        return builder;
    }
}

