/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.kafka.connect.utils.config.ConfigUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ValidEnum
implements ConfigDef.Validator {
    final Set<String> validEnums;
    final Class<?> enumClass;

    public static ValidEnum of(Class<?> enumClass, String ... excludes) {
        return new ValidEnum(enumClass, excludes);
    }

    private ValidEnum(Class<?> enumClass, String ... excludes) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Object o : enumClass.getEnumConstants()) {
            String key = o.toString();
            validEnums.add(key);
        }
        validEnums.removeAll(Arrays.asList(excludes));
        this.validEnums = validEnums;
        this.enumClass = enumClass;
    }

    public void ensureValid(String s, Object o) {
        if (!this.validEnums.contains(o)) {
            throw new ConfigException(s, (Object)String.format("'%s' is not a valid value for %s. Valid values are %s.", o, this.enumClass.getSimpleName(), ConfigUtils.enumValues(this.enumClass)));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enum", (Object)this.enumClass.getSimpleName()).add("allowed", this.validEnums).toString();
    }
}

