/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.repackaged.com.google.common.base.MoreObjects;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import org.apache.kafka.common.config.ConfigDef;

public class ValidPort
implements ConfigDef.Validator {
    final int start;
    final int end;

    ValidPort(int start, int end) {
        Preconditions.checkState(start > 0, "start must be greater than 0.");
        Preconditions.checkState(end > 0, "end must be greater than 0.");
        Preconditions.checkState(start <= 65535, "start must be less than or equal to 65535.");
        Preconditions.checkState(end <= 65535, "end must be less than or equal to 65535.");
        Preconditions.checkState(end > start, "end must be less than or equal to 65535.");
        this.start = start;
        this.end = end;
    }

    public static ValidPort of() {
        return ValidPort.of(1025, 65535);
    }

    public static ValidPort of(int start, int end) {
        return new ValidPort(start, end);
    }

    public void ensureValid(String setting, Object value) {
        Preconditions.checkState(value instanceof Integer, "%s must be an integer.", (Object)setting);
        Integer port = (Integer)value;
        Preconditions.checkState(port >= this.start && port <= this.end, "'%s'(%s) must be between %s and %s.", (Object)setting, (Object)port, (Object)this.start, (Object)this.end);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("start", this.start).add("end", this.end).toString();
    }
}

