/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.ConfigProviderExample", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConfigProviderExample
implements Plugin.ConfigProviderExample {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;
    @Nullable
    private final List<Notes.Section> sections;
    private final String name;
    private final Map<String, String> config;
    private final String prefix;
    private final Map<String, String> connectorConfig;

    private ImmutableConfigProviderExample(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction, @Nullable List<Notes.Section> sections, String name, Map<String, String> config, String prefix, Map<String, String> connectorConfig) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
        this.sections = sections;
        this.name = name;
        this.config = config;
        this.prefix = prefix;
        this.connectorConfig = connectorConfig;
    }

    @Override
    @JsonProperty(value="warning")
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @JsonProperty(value="tip")
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @JsonProperty(value="important")
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @JsonProperty(value="danger")
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @JsonProperty(value="note")
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="icon")
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="introduction")
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    @JsonProperty(value="sections")
    @Nullable
    public List<Notes.Section> getSections() {
        return this.sections;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Map<String, String> getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @JsonProperty(value="connectorConfig")
    public Map<String, String> getConnectorConfig() {
        return this.connectorConfig;
    }

    public final ImmutableConfigProviderExample withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value, this.sections, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withSections(Notes.Section ... elements) {
        if (elements == null) {
            return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, null, this.name, this.config, this.prefix, this.connectorConfig);
        }
        List<Notes.Section> newValue = Arrays.asList(elements) == null ? null : ImmutableConfigProviderExample.createUnmodifiableList(false, ImmutableConfigProviderExample.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, newValue, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withSections(@Nullable Iterable<? extends Notes.Section> elements) {
        if (this.sections == elements) {
            return this;
        }
        List<Notes.Section> newValue = elements == null ? null : ImmutableConfigProviderExample.createUnmodifiableList(false, ImmutableConfigProviderExample.createSafeList(elements, true, false));
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, newValue, this.name, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, newValue, this.config, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableConfigProviderExample.createUnmodifiableMap(true, false, entries);
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, newValue, this.prefix, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, newValue, this.connectorConfig);
    }

    public final ImmutableConfigProviderExample withConnectorConfig(Map<String, ? extends String> entries) {
        if (this.connectorConfig == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableConfigProviderExample.createUnmodifiableMap(true, false, entries);
        return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.name, this.config, this.prefix, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigProviderExample && this.equalTo((ImmutableConfigProviderExample)another);
    }

    private boolean equalTo(ImmutableConfigProviderExample another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction) && Objects.equals(this.sections, another.sections) && this.name.equals(another.name) && this.config.equals(another.config) && this.prefix.equals(another.prefix) && this.connectorConfig.equals(another.connectorConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warning);
        h += (h << 5) + Objects.hashCode(this.tip);
        h += (h << 5) + Objects.hashCode(this.important);
        h += (h << 5) + Objects.hashCode(this.danger);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.introduction);
        h += (h << 5) + Objects.hashCode(this.sections);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.connectorConfig.hashCode();
        return h;
    }

    public String toString() {
        return "ConfigProviderExample{warning=" + this.warning + ", tip=" + this.tip + ", important=" + this.important + ", danger=" + this.danger + ", note=" + this.note + ", title=" + this.title + ", description=" + this.description + ", icon=" + this.icon + ", introduction=" + this.introduction + ", sections=" + this.sections + ", name=" + this.name + ", config=" + this.config + ", prefix=" + this.prefix + ", connectorConfig=" + this.connectorConfig + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConfigProviderExample fromJson(Json json) {
        Builder builder = ImmutableConfigProviderExample.builder();
        if (json.warning != null) {
            builder.warning(json.warning);
        }
        if (json.tip != null) {
            builder.tip(json.tip);
        }
        if (json.important != null) {
            builder.important(json.important);
        }
        if (json.danger != null) {
            builder.danger(json.danger);
        }
        if (json.note != null) {
            builder.note(json.note);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.introduction != null) {
            builder.introduction(json.introduction);
        }
        if (json.sections != null) {
            builder.addAllSections(json.sections);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.putAllConfig(json.config);
        }
        if (json.prefix != null) {
            builder.prefix(json.prefix);
        }
        if (json.connectorConfig != null) {
            builder.putAllConnectorConfig(json.connectorConfig);
        }
        return builder.build();
    }

    public static ImmutableConfigProviderExample copyOf(Plugin.ConfigProviderExample instance) {
        if (instance instanceof ImmutableConfigProviderExample) {
            return (ImmutableConfigProviderExample)instance;
        }
        return ImmutableConfigProviderExample.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Plugin.ConfigProviderExample", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PREFIX = 2L;
        private long initBits = 3L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;
        private List<Notes.Section> sections = null;
        @Nullable
        private String name;
        private Map<String, String> config = new LinkedHashMap<String, String>();
        @Nullable
        private String prefix;
        private Map<String, String> connectorConfig = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.ConfigProviderExample instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Example instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Notes instance;
            if (object instanceof Notes) {
                String introductionValue;
                List<Notes.Section> sectionsValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String warningValue;
                String descriptionValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((sectionsValue = instance.getSections()) != null) {
                    this.addAllSections(sectionsValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
            if (object instanceof Plugin.ConfigProviderExample) {
                instance = (Plugin.ConfigProviderExample)object;
                this.putAllConnectorConfig(instance.getConnectorConfig());
                this.prefix(instance.getPrefix());
            }
            if (object instanceof Plugin.Example) {
                instance = (Plugin.Example)object;
                this.name(instance.getName());
                this.putAllConfig(instance.getConfig());
            }
        }

        @JsonProperty(value="warning")
        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @JsonProperty(value="tip")
        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @JsonProperty(value="important")
        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @JsonProperty(value="danger")
        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @JsonProperty(value="note")
        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="icon")
        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @JsonProperty(value="introduction")
        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section element) {
            if (this.sections == null) {
                this.sections = new ArrayList<Notes.Section>();
            }
            this.sections.add(Objects.requireNonNull(element, "sections element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section ... elements) {
            if (this.sections == null) {
                this.sections = new ArrayList<Notes.Section>();
            }
            for (Notes.Section element : elements) {
                this.sections.add(Objects.requireNonNull(element, "sections element"));
            }
            return this;
        }

        @JsonProperty(value="sections")
        @CanIgnoreReturnValue
        public final Builder sections(@Nullable Iterable<? extends Notes.Section> elements) {
            if (elements == null) {
                this.sections = null;
                return this;
            }
            this.sections = new ArrayList<Notes.Section>();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Notes.Section> elements) {
            Objects.requireNonNull(elements, "sections element");
            if (this.sections == null) {
                this.sections = new ArrayList<Notes.Section>();
            }
            for (Notes.Section section : elements) {
                this.sections.add(Objects.requireNonNull(section, "sections element"));
            }
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, "config value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, "config value"));
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, "config value"));
            }
            return this;
        }

        @JsonProperty(value="prefix")
        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConnectorConfig(String key, String value) {
            this.connectorConfig.put(Objects.requireNonNull(key, "connectorConfig key"), Objects.requireNonNull(value, "connectorConfig value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConnectorConfig(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.connectorConfig.put(Objects.requireNonNull(k, "connectorConfig key"), Objects.requireNonNull(v, "connectorConfig value"));
            return this;
        }

        @JsonProperty(value="connectorConfig")
        @CanIgnoreReturnValue
        public final Builder connectorConfig(Map<String, ? extends String> entries) {
            this.connectorConfig.clear();
            return this.putAllConnectorConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConnectorConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.connectorConfig.put(Objects.requireNonNull(k, "connectorConfig key"), Objects.requireNonNull(v, "connectorConfig value"));
            }
            return this;
        }

        public ImmutableConfigProviderExample build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigProviderExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections == null ? null : ImmutableConfigProviderExample.createUnmodifiableList(true, this.sections), this.name, ImmutableConfigProviderExample.createUnmodifiableMap(false, false, this.config), this.prefix, ImmutableConfigProviderExample.createUnmodifiableMap(false, false, this.connectorConfig));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("prefix");
            }
            return "Cannot build ConfigProviderExample, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Plugin.ConfigProviderExample", generator="Immutables")
    static final class Json
    implements Plugin.ConfigProviderExample {
        @Nullable
        String warning;
        @Nullable
        String tip;
        @Nullable
        String important;
        @Nullable
        String danger;
        @Nullable
        String note;
        @Nullable
        String title;
        @Nullable
        String description;
        @Nullable
        String icon;
        @Nullable
        String introduction;
        @Nullable
        List<Notes.Section> sections = null;
        @Nullable
        String name;
        @Nullable
        Map<String, String> config = Collections.emptyMap();
        @Nullable
        String prefix;
        @Nullable
        Map<String, String> connectorConfig = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="warning")
        public void setWarning(@Nullable String warning) {
            this.warning = warning;
        }

        @JsonProperty(value="tip")
        public void setTip(@Nullable String tip) {
            this.tip = tip;
        }

        @JsonProperty(value="important")
        public void setImportant(@Nullable String important) {
            this.important = important;
        }

        @JsonProperty(value="danger")
        public void setDanger(@Nullable String danger) {
            this.danger = danger;
        }

        @JsonProperty(value="note")
        public void setNote(@Nullable String note) {
            this.note = note;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="icon")
        public void setIcon(@Nullable String icon) {
            this.icon = icon;
        }

        @JsonProperty(value="introduction")
        public void setIntroduction(@Nullable String introduction) {
            this.introduction = introduction;
        }

        @JsonProperty(value="sections")
        public void setSections(@Nullable List<Notes.Section> sections) {
            this.sections = sections;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Map<String, String> config) {
            this.config = config;
        }

        @JsonProperty(value="prefix")
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @JsonProperty(value="connectorConfig")
        public void setConnectorConfig(Map<String, String> connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public String getWarning() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTip() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImportant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDanger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNote() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIntroduction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Notes.Section> getSections() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getConnectorConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

