/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableConfigProviderExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableConverterExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSinkConnectorExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSourceConnectorExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableTransformationExample;
import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.immutables.value.Value;

@Value.Immutable
public interface Plugin
extends Notes {
    @Override
    public String getIntroduction();

    public String getPluginName();

    public String getPluginOwner();

    public List<Transformation> getTransformations();

    public List<SinkConnector> getSinkConnectors();

    public List<SourceConnector> getSourceConnectors();

    public List<Converter> getConverters();

    public List<ConfigProvider> getConfigProviders();

    @Value.Immutable
    public static interface SchemaInput {
        @Nullable
        public String getName();

        @Nullable
        @Value.Derived
        default public String getSchemaLink() {
            String name = this.getName();
            if (Strings.isNullOrEmpty((String)name)) {
                return String.format("schema-%s", this.getType()).toLowerCase();
            }
            return String.format("schema-%s", name).replace('.', '-').toLowerCase();
        }

        @Nullable
        @Value.Derived
        default public String getShortName() {
            String name = this.getName();
            if (Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            String shortName = Files.getFileExtension((String)name);
            return shortName;
        }

        @Nullable
        public String getDoc();

        public boolean isOptional();

        public Schema.Type getType();

        @Nullable
        public String getFieldName();

        @Nullable
        public List<SchemaInput> getFields();

        @Nullable
        public SchemaInput key();

        @Nullable
        public SchemaInput value();

        @Value.Derived
        default public String getRefLink() {
            StringBuilder builder = new StringBuilder();
            if (Schema.Type.MAP == this.getType()) {
                builder.append(":ref:`schema-map`");
                builder.append(" < ");
                builder.append(":ref:`");
                builder.append(this.key().getSchemaLink());
                builder.append("` , :ref:`");
                builder.append(this.value().getSchemaLink());
                builder.append("` > ");
            } else if (Schema.Type.ARRAY == this.getType()) {
                builder.append(":ref:`schema-array`");
                builder.append(" < ");
                builder.append(":ref:`");
                builder.append(this.value().getSchemaLink());
                builder.append("` >");
            } else {
                builder.append(":ref:`");
                builder.append(this.getSchemaLink());
                builder.append('`');
            }
            return builder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Value.Derived
        default public String getTable() {
            void var6_10;
            StringBuilder builder = new StringBuilder();
            List<String> headers = Arrays.asList("Name", "Type", "Required", "Description");
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            rows.add(headers);
            if (null != this.getFields()) {
                for (SchemaInput field : this.getFields()) {
                    rows.add(Arrays.asList(field.getFieldName(), field.getRefLink(), Boolean.toString(!field.isOptional()), Strings.isNullOrEmpty((String)field.getDoc()) ? "" : field.getDoc()));
                }
            }
            ArrayList<Integer> rowSizes = new ArrayList<Integer>();
            for (int i = 0; i < headers.size(); ++i) {
                rowSizes.add(0);
            }
            for (List list : rows) {
                for (int i = 0; i < headers.size(); ++i) {
                    int current = (Integer)rowSizes.get(i);
                    int cellLength = ((String)list.get(i)).length();
                    rowSizes.set(i, Math.max(current, cellLength));
                }
            }
            String rowFormat = "\n|";
            String string = "\n+";
            String headerEndFormat = "\n+";
            for (Integer size : rowSizes) {
                rowFormat = rowFormat + " %s |";
                String string2 = (String)var6_10 + Strings.repeat((String)"-", (int)(size + 2)) + "+";
                headerEndFormat = headerEndFormat + Strings.repeat((String)"=", (int)(size + 2)) + "+";
            }
            String finalRowFormat = rowFormat;
            Function<List, String> formatRow = row -> {
                Object[] padded = new String[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    String value = (String)row.get(i);
                    Integer expectedSize = (Integer)rowSizes.get(i);
                    padded[i] = Strings.padEnd((String)value, (int)expectedSize, (char)' ');
                }
                return String.format(finalRowFormat, padded);
            };
            builder.append((String)var6_10);
            builder.append(formatRow.apply(headers));
            builder.append(headerEndFormat);
            for (int rowIndex = 1; rowIndex < rows.size(); ++rowIndex) {
                List row3 = (List)rows.get(rowIndex);
                builder.append(formatRow.apply(row3));
                builder.append((String)var6_10);
            }
            return builder.toString();
        }
    }

    @Value.Immutable
    public static interface SourceConnectorExampleInput
    extends ExampleInput<SourceConnectorExample> {
        @Nullable
        public String getOutputJson();

        @Nullable
        public String getOutputDescription();
    }

    @Value.Immutable
    public static interface SinkConnectorExampleInput
    extends ExampleInput<SinkConnectorExample> {
        @Nullable
        public String getInputJson();

        @Nullable
        public String getInputDescription();

        @Nullable
        public String getOutputJson();

        @Nullable
        public String getOutputDescription();
    }

    @Value.Immutable
    public static interface TransformationExampleInput
    extends ExampleInput<TransformationExample> {
        public List<Integer> getInputEmphasizeLines();

        @Nullable
        public String getInputJson();

        public List<Integer> getOutputEmphasizeLines();

        @Nullable
        public String getOutputJson();
    }

    @Value.Immutable
    public static interface ConverterExampleInput
    extends ExampleInput<ConverterExample> {
        public String getWorkerKeyConfig();

        public String getWorkerValueConfig();

        public String getConnectorKeyConfig();

        public String getConnectorValueConfig();
    }

    @Value.Immutable
    public static interface ConfigProviderExampleInput
    extends ExampleInput<ConfigProviderExample> {
        public String getConnectorConfig();
    }

    public static interface ExampleInput<T extends Example> {
        @Nullable
        public String getConfig();

        public T getExample();
    }

    @JsonSerialize(as=ImmutableConfigProviderExample.class)
    @JsonDeserialize(as=ImmutableConfigProviderExample.class)
    @JsonPropertyOrder(value={"title", "warning", "tip", "important", "danger", "note", "settings"})
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface ConfigProviderExample
    extends Example {
        @JsonProperty(value="prefix")
        public String getPrefix();

        @JsonProperty(value="connectorConfig")
        public Map<String, String> getConnectorConfig();
    }

    @JsonSerialize(as=ImmutableConverterExample.class)
    @JsonDeserialize(as=ImmutableConverterExample.class)
    @JsonPropertyOrder(value={"title", "warning", "tip", "important", "danger", "note", "settings"})
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface ConverterExample
    extends Example {
    }

    @JsonSerialize(as=ImmutableTransformationExample.class)
    @JsonDeserialize(as=ImmutableTransformationExample.class)
    @JsonPropertyOrder(value={"title", "warning", "tip", "important", "danger", "note", "settings", "input", "output", "inputFocus", "outputFocus"})
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface TransformationExample
    extends Example {
        @Nullable
        public String getChildClass();

        @Nullable
        @JsonProperty(value="input")
        public SinkRecord getInput();
    }

    @JsonSerialize(as=ImmutableSourceConnectorExample.class)
    @JsonDeserialize(as=ImmutableSourceConnectorExample.class)
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface SourceConnectorExample
    extends ConnectorExample {
        @Nullable
        @JsonProperty(value="output")
        public SourceRecord getOutput();
    }

    @JsonSerialize(as=ImmutableSinkConnectorExample.class)
    @JsonDeserialize(as=ImmutableSinkConnectorExample.class)
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface SinkConnectorExample
    extends ConnectorExample {
        @Nullable
        @JsonProperty(value="input")
        public SinkRecord getInput();

        @Nullable
        @JsonProperty(value="output")
        public Object getOutput();
    }

    public static interface ConnectorExample
    extends Example {
        @JsonProperty(value="transformations")
        public Map<String, Map<String, String>> transformations();
    }

    public static interface Example
    extends Notes {
        @JsonProperty(value="name")
        public String getName();

        @JsonProperty(value="config")
        public Map<String, String> getConfig();
    }

    @Value.Immutable
    public static interface Transformation
    extends Configurable {
        public boolean isKeyValue();

        @Nullable
        public Class getKey();

        @Nullable
        public Class getValue();
    }

    @Value.Immutable
    public static interface SinkConnector
    extends Connector {
    }

    @Value.Immutable
    public static interface SourceConnector
    extends Connector {
    }

    public static interface Connector
    extends Configurable {
    }

    @Value.Immutable
    public static interface Configuration {
        public ConfigDef getConfigDef();

        public List<Group> getGroups();

        public List<Item> getRequiredConfigs();
    }

    public static interface Configurable
    extends Notes {
        public Class getCls();

        @Nullable
        public Configuration getConfiguration();

        public List<String> getExamples();
    }

    @Value.Immutable
    public static interface ConfigProvider
    extends Configurable {
    }

    @Value.Immutable
    public static interface Converter
    extends Configurable {
    }

    @Value.Immutable
    public static interface Group {
        public String getName();

        public List<Item> getItems();
    }

    @Value.Immutable
    public static interface Item {
        public String getName();

        public ConfigDef.Importance getImportance();

        public String getDoc();

        @Nullable
        public Object getDefaultValue();

        @Nullable
        public ConfigDef.Validator getValidator();

        public ConfigDef.Type getType();

        public String getGroup();

        public boolean isRequired();
    }
}

