/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.config.ConfigKeyComparator;
import com.github.jcustenborder.kafka.connect.utils.templates.AnnotationHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableConfigProvider;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableConfiguration;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableConverter;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableGroup;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableItem;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutablePlugin;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSinkConnector;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSourceConnector;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableTransformation;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.transforms.Transformation;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    static final Set<String> KEY_OR_VALUE = ImmutableSet.of((Object)"Key", (Object)"Value");
    static final String GENERAL_GROUP = "General";
    private static final Logger log = LoggerFactory.getLogger(PluginLoader.class);
    final Package pkg;
    final Reflections reflections;
    private List<Plugin.SourceConnector> sourceConnectors;
    private List<Plugin.SinkConnector> sinkConnectors;
    private List<Plugin.Transformation> transformations;
    private List<Plugin.Converter> converters;
    private List<Plugin.ConfigProvider> configProviders;
    private Set<String> allResources;

    public PluginLoader(Package pkg) {
        this.pkg = pkg;
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(new String[]{pkg.getName()}).addScanners(new Scanner[]{new ResourcesScanner()}));
    }

    ConfigDef configDef(Class<?> pluginClass) {
        ConfigDef result;
        block7: {
            try {
                if (Connector.class.isAssignableFrom(pluginClass)) {
                    Connector connector = (Connector)pluginClass.newInstance();
                    result = connector.config();
                    break block7;
                }
                if (Transformation.class.isAssignableFrom(pluginClass)) {
                    Transformation connector = (Transformation)pluginClass.newInstance();
                    result = connector.config();
                    break block7;
                }
                if (Converter.class.isAssignableFrom(pluginClass) || ConfigProvider.class.isAssignableFrom(pluginClass)) {
                    Optional<Method> optionalConfigMethod = Stream.of(pluginClass.getMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> ConfigDef.class.equals(method.getReturnType())).findFirst();
                    if (optionalConfigMethod.isPresent()) {
                        Method configMethod = optionalConfigMethod.get();
                        Object instance = Modifier.isStatic(configMethod.getModifiers()) ? null : pluginClass.newInstance();
                        result = (ConfigDef)configMethod.invoke(instance, new Object[0]);
                    } else {
                        result = null;
                    }
                    break block7;
                }
                throw new UnsupportedOperationException(String.format("Type %s is not supported", pluginClass.getName()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    Set<Class<? extends Transformation>> findTransformations() {
        Set transforms = this.reflections.getSubTypesOf(Transformation.class).stream().filter(c -> c.getName().startsWith(this.pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0)).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<Class<? extends Transformation>> result = new LinkedHashSet<Class<? extends Transformation>>();
        for (Class cls : transforms) {
            log.trace("findTransformations() - simpleName = '{}'", (Object)cls.getSimpleName());
            if (KEY_OR_VALUE.contains(cls.getSimpleName()) && null != cls.getDeclaringClass()) {
                result.add(cls.getDeclaringClass().asSubclass(Transformation.class));
                continue;
            }
            result.add(cls);
        }
        return result;
    }

    Set<Class<? extends SinkConnector>> findSinkConnectors() {
        return this.reflections.getSubTypesOf(SinkConnector.class).stream().filter(c -> c.getName().startsWith(this.pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0)).collect(Collectors.toSet());
    }

    Set<Class<? extends SourceConnector>> findSourceConnectors() {
        return this.reflections.getSubTypesOf(SourceConnector.class).stream().filter(c -> c.getName().startsWith(this.pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0)).collect(Collectors.toSet());
    }

    Set<Class<? extends Converter>> findConverters() {
        return this.reflections.getSubTypesOf(Converter.class).stream().filter(c -> c.getName().startsWith(this.pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0)).collect(Collectors.toSet());
    }

    Set<Class<? extends ConfigProvider>> findConfigProviders() {
        return this.reflections.getSubTypesOf(ConfigProvider.class).stream().filter(c -> c.getName().startsWith(this.pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0)).collect(Collectors.toSet());
    }

    Plugin.Configuration config(Class<?> pluginClass) {
        ConfigDef config = this.configDef(pluginClass);
        if (null == config) {
            return null;
        }
        ImmutableConfiguration.Builder configBuilder = ImmutableConfiguration.builder().configDef(config);
        LinkedHashMap groupBuilderCache = new LinkedHashMap();
        List configKeys = config.configKeys().values().stream().sorted(ConfigKeyComparator.INSTANCE).collect(Collectors.toList());
        for (ConfigDef.ConfigKey configKey : configKeys) {
            String group = Strings.isNullOrEmpty((String)configKey.group) ? GENERAL_GROUP : configKey.group;
            ImmutableItem item = ImmutableItem.builder().defaultValue(ConfigDef.NO_DEFAULT_VALUE.equals(configKey.defaultValue) ? null : configKey.defaultValue).doc(configKey.documentation).group(group).importance(configKey.importance).isRequired(!configKey.hasDefault()).name(configKey.name).type(configKey.type).validator(configKey.validator).build();
            ImmutableGroup.Builder groupBuilder = (ImmutableGroup.Builder)groupBuilderCache.computeIfAbsent(group, s -> ImmutableGroup.builder().name(group));
            groupBuilder.addItems((Plugin.Item)item);
            if (!item.isRequired()) continue;
            configBuilder.addRequiredConfigs((Plugin.Item)item);
        }
        groupBuilderCache.values().stream().map(ImmutableGroup.Builder::build).forEach(configBuilder::addGroups);
        return configBuilder.build();
    }

    public Plugin load() {
        ImmutablePlugin.Builder builder = ImmutablePlugin.builder().from(AnnotationHelper.notes(this.pkg)).pluginName(AnnotationHelper.pluginName(this.pkg)).pluginOwner(AnnotationHelper.pluginOwner(this.pkg));
        List<Plugin.Transformation> transformations = this.loadTransformations();
        builder.addAllTransformations(transformations);
        List<Plugin.SinkConnector> sinkConnectors = this.loadSinkConnectors();
        builder.addAllSinkConnectors(sinkConnectors);
        List<Plugin.SourceConnector> sourceConnectors = this.loadSourceConnectors();
        builder.addAllSourceConnectors(sourceConnectors);
        List<Plugin.Converter> converters = this.loadConverters();
        builder.addAllConverters(converters);
        List<Plugin.ConfigProvider> configProviders = this.loadConfigProviders();
        builder.addAllConfigProviders(configProviders);
        return builder.build();
    }

    private List<Plugin.Converter> loadConverters() {
        if (null != this.converters) {
            return this.converters;
        }
        ArrayList<Plugin.Converter> result = new ArrayList<Plugin.Converter>();
        Set<Class<? extends Converter>> converters = this.findConverters();
        for (Class<? extends Converter> cls : converters) {
            log.trace("loadConverters() - processing {}", (Object)cls.getName());
            ImmutableConverter.Builder builder = ImmutableConverter.builder().cls(cls).from(AnnotationHelper.notes(cls));
            Plugin.Configuration configuration = this.config(cls);
            if (null != configuration) {
                builder.configuration(configuration);
            }
            List<String> examples = this.findExamples(cls);
            builder.addAllExamples(examples);
            result.add(builder.build());
        }
        this.converters = result;
        return this.converters;
    }

    private List<Plugin.ConfigProvider> loadConfigProviders() {
        if (null != this.configProviders) {
            return this.configProviders;
        }
        ArrayList<Plugin.ConfigProvider> result = new ArrayList<Plugin.ConfigProvider>();
        Set<Class<? extends ConfigProvider>> configProviders = this.findConfigProviders();
        for (Class<? extends ConfigProvider> cls : configProviders) {
            log.trace("loadConfigProviders() - processing {}", (Object)cls.getName());
            ImmutableConfigProvider.Builder builder = ImmutableConfigProvider.builder().cls(cls).from(AnnotationHelper.notes(cls));
            Plugin.Configuration configuration = this.config(cls);
            if (null != configuration) {
                builder.configuration(configuration);
            }
            List<String> examples = this.findExamples(cls);
            builder.addAllExamples(examples);
            result.add(builder.build());
        }
        this.configProviders = result;
        return this.configProviders;
    }

    private List<Plugin.SourceConnector> loadSourceConnectors() {
        if (null != this.sourceConnectors) {
            return this.sourceConnectors;
        }
        ArrayList<Plugin.SourceConnector> result = new ArrayList<Plugin.SourceConnector>();
        Set<Class<? extends SourceConnector>> sourceConnectors = this.findSourceConnectors();
        for (Class<? extends SourceConnector> cls : sourceConnectors) {
            log.trace("loadSourceConnectors() - processing {}", (Object)cls.getName());
            ImmutableSourceConnector.Builder builder = ImmutableSourceConnector.builder().cls(cls).configuration(this.config(cls)).from(AnnotationHelper.notes(cls));
            List<String> examples = this.findExamples(cls);
            builder.addAllExamples(examples);
            result.add(builder.build());
        }
        this.sourceConnectors = result;
        return this.sourceConnectors;
    }

    private List<Plugin.SinkConnector> loadSinkConnectors() {
        if (null != this.sinkConnectors) {
            return this.sinkConnectors;
        }
        ArrayList<Plugin.SinkConnector> result = new ArrayList<Plugin.SinkConnector>();
        Set<Class<? extends SinkConnector>> sinkConnectors = this.findSinkConnectors();
        for (Class<? extends SinkConnector> cls : sinkConnectors) {
            log.trace("loadSinkConnectors() - processing {}", (Object)cls.getName());
            ImmutableSinkConnector.Builder builder = ImmutableSinkConnector.builder().cls(cls).configuration(this.config(cls)).from(AnnotationHelper.notes(cls));
            List<String> examples = this.findExamples(cls);
            builder.addAllExamples(examples);
            result.add(builder.build());
        }
        this.sinkConnectors = result;
        return this.sinkConnectors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Plugin.Transformation> loadTransformations() {
        if (null != this.transformations) {
            return this.transformations;
        }
        ArrayList<Plugin.Transformation> result = new ArrayList<Plugin.Transformation>();
        Set<Class<? extends Transformation>> tranformations = this.findTransformations();
        for (Class<? extends Transformation> cls : tranformations) {
            Plugin.Configuration configuration;
            log.trace("loadTransformations() - processing {}", (Object)cls.getName());
            ImmutableTransformation.Builder builder = ImmutableTransformation.builder().cls(cls).from(AnnotationHelper.notes(cls));
            Class<?>[] classes = cls.getClasses();
            boolean isKeyValue = false;
            Class<?> keyClass = null;
            Class<?> valueClass = null;
            if (null != classes) {
                for (Class<?> c : classes) {
                    if ("Key".equals(c.getSimpleName())) {
                        keyClass = c;
                        isKeyValue = true;
                        continue;
                    }
                    if (!"Value".equals(c.getSimpleName())) continue;
                    isKeyValue = true;
                    valueClass = c;
                }
            } else {
                isKeyValue = false;
            }
            builder.isKeyValue(isKeyValue);
            if (null != keyClass) {
                builder.key(keyClass);
            }
            if (null != valueClass) {
                builder.value(valueClass);
            }
            if (isKeyValue) {
                if (null != keyClass) {
                    configuration = this.config(keyClass);
                } else {
                    if (null == valueClass) throw new IllegalStateException("key and value class null");
                    configuration = this.config(valueClass);
                }
            } else {
                configuration = this.config(cls);
            }
            builder.configuration(configuration);
            List<String> examples = this.findExamples(cls);
            builder.addAllExamples(examples);
            result.add(builder.build());
        }
        this.transformations = result;
        return this.transformations;
    }

    private Set<String> allResources() {
        Set result = null == this.allResources ? (this.allResources = this.reflections.getResources(s -> s.endsWith(".json"))) : this.allResources;
        return result;
    }

    private List<String> findExamples(Class<?> cls) {
        String examplePrefix = cls.getName().replace('.', '/') + "/";
        log.trace("findExamples() - Searching for examples for '{}' with '{}'", (Object)cls.getName(), (Object)examplePrefix);
        return this.allResources().stream().filter(s -> s.startsWith(examplePrefix)).map(e -> "/" + e).collect(Collectors.toList());
    }
}

