/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Strings;

public class StructHelper {
    private StructHelper() {
    }

    public static SchemaAndValue asSchemaAndValue(Struct struct) {
        Preconditions.checkNotNull((Object)struct, (Object)"struct cannot be null.");
        return new SchemaAndValue(struct.schema(), (Object)struct);
    }

    public static Map<String, Object> asMap(Struct struct) {
        Preconditions.checkNotNull((Object)struct, (Object)"struct cannot be null.");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(struct.schema().fields().size());
        for (Field field : struct.schema().fields()) {
            Map<String, Object> value;
            if (Schema.Type.STRUCT == field.schema().type()) {
                Struct s = struct.getStruct(field.name());
                value = StructHelper.asMap(s);
            } else {
                value = struct.get(field);
            }
            result.put(field.name(), value);
        }
        return result;
    }

    private static Struct struct(String name, List<FieldState> fields) {
        SchemaBuilder builder = SchemaBuilder.struct();
        if (!Strings.isNullOrEmpty((String)name)) {
            builder.name(name);
        }
        for (FieldState field : fields) {
            Schema schema;
            if (Schema.Type.STRUCT == field.type) {
                Preconditions.checkNotNull((Object)field.value, (Object)"%s field.value cannot be null. Struct is needed to infer schema of nested struct.");
                Struct struct = (Struct)field.value;
                schema = struct.schema();
            } else {
                SchemaBuilder fieldBuilder = SchemaBuilder.type((Schema.Type)field.type);
                if (field.isOptional) {
                    fieldBuilder.optional();
                }
                schema = fieldBuilder.build();
            }
            builder.field(field.name, schema);
        }
        Schema schema = builder.build();
        Struct struct = new Struct(schema);
        for (FieldState field : fields) {
            struct.put(field.name, field.value);
        }
        struct.validate();
        return struct;
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1) {
        return StructHelper.struct(name, Collections.singletonList(FieldState.of(f1, t1, o1, v1)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5, String f6, Schema.Type t6, boolean o6, Object v6) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5), FieldState.of(f6, t6, o6, v6)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5, String f6, Schema.Type t6, boolean o6, Object v6, String f7, Schema.Type t7, boolean o7, Object v7) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5), FieldState.of(f6, t6, o6, v6), FieldState.of(f7, t7, o7, v7)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5, String f6, Schema.Type t6, boolean o6, Object v6, String f7, Schema.Type t7, boolean o7, Object v7, String f8, Schema.Type t8, boolean o8, Object v8) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5), FieldState.of(f6, t6, o6, v6), FieldState.of(f7, t7, o7, v7), FieldState.of(f8, t8, o8, v8)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5, String f6, Schema.Type t6, boolean o6, Object v6, String f7, Schema.Type t7, boolean o7, Object v7, String f8, Schema.Type t8, boolean o8, Object v8, String f9, Schema.Type t9, boolean o9, Object v9) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5), FieldState.of(f6, t6, o6, v6), FieldState.of(f7, t7, o7, v7), FieldState.of(f8, t8, o8, v8), FieldState.of(f9, t9, o9, v9)));
    }

    public static Struct struct(String name, String f1, Schema.Type t1, boolean o1, Object v1, String f2, Schema.Type t2, boolean o2, Object v2, String f3, Schema.Type t3, boolean o3, Object v3, String f4, Schema.Type t4, boolean o4, Object v4, String f5, Schema.Type t5, boolean o5, Object v5, String f6, Schema.Type t6, boolean o6, Object v6, String f7, Schema.Type t7, boolean o7, Object v7, String f8, Schema.Type t8, boolean o8, Object v8, String f9, Schema.Type t9, boolean o9, Object v9, String f10, Schema.Type t10, boolean o10, Object v10) {
        return StructHelper.struct(name, Arrays.asList(FieldState.of(f1, t1, o1, v1), FieldState.of(f2, t2, o2, v2), FieldState.of(f3, t3, o3, v3), FieldState.of(f4, t4, o4, v4), FieldState.of(f5, t5, o5, v5), FieldState.of(f6, t6, o6, v6), FieldState.of(f7, t7, o7, v7), FieldState.of(f8, t8, o8, v8), FieldState.of(f9, t9, o9, v9), FieldState.of(f10, t10, o10, v10)));
    }

    static class FieldState {
        final String name;
        final Schema.Type type;
        final boolean isOptional;
        final Object value;

        private FieldState(String name, Schema.Type type, boolean isOptional, Object value) {
            this.name = name;
            this.type = type;
            this.isOptional = isOptional;
            this.value = value;
        }

        static FieldState of(String name, Schema.Type type, boolean isOptional, Object value) {
            return new FieldState(name, type, isOptional, value);
        }
    }
}

