/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSinkConnectorExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSourceConnectorExample;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableTransformationExample;
import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.immutables.value.Value;

@Value.Immutable
public interface Plugin
extends Notes {
    @Override
    public String getIntroduction();

    public String getPluginName();

    public String getPluginOwner();

    public List<Transformation> getTransformations();

    public List<SinkConnector> getSinkConnectors();

    public List<SourceConnector> getSourceConnectors();

    public List<Converter> getConverters();

    @Value.Immutable
    public static interface SourceConnectorExampleInput {
        @Nullable
        public String getConfig();

        public SourceConnectorExample getExample();

        @Nullable
        public String getOutputJson();

        @Nullable
        public String getOutputDescription();
    }

    @Value.Immutable
    public static interface SinkConnectorExampleInput {
        @Nullable
        public String getConfig();

        public SinkConnectorExample getExample();

        @Nullable
        public String getInputJson();

        @Nullable
        public String getInputDescription();

        @Nullable
        public String getOutputJson();

        @Nullable
        public String getOutputDescription();
    }

    @Value.Immutable
    public static interface TransformationExampleInput {
        @Nullable
        public String getConfig();

        public List<Integer> getInputEmphasizeLines();

        @Nullable
        public String getInputJson();

        public List<Integer> getOutputEmphasizeLines();

        @Nullable
        public String getOutputJson();

        public TransformationExample getExample();
    }

    @JsonSerialize(as=ImmutableTransformationExample.class)
    @JsonDeserialize(as=ImmutableTransformationExample.class)
    @JsonPropertyOrder(value={"title", "warning", "tip", "important", "danger", "note", "settings", "input", "output", "inputFocus", "outputFocus"})
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface TransformationExample
    extends Example {
        @Nullable
        public String getChildClass();

        @Nullable
        @JsonProperty(value="input")
        public SinkRecord getInput();
    }

    @JsonSerialize(as=ImmutableSourceConnectorExample.class)
    @JsonDeserialize(as=ImmutableSourceConnectorExample.class)
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface SourceConnectorExample
    extends ConnectorExample {
        @Nullable
        @JsonProperty(value="output")
        public SourceRecord getOutput();
    }

    @JsonSerialize(as=ImmutableSinkConnectorExample.class)
    @JsonDeserialize(as=ImmutableSinkConnectorExample.class)
    @Value.Style(jdkOnly=true)
    @Value.Immutable
    public static interface SinkConnectorExample
    extends ConnectorExample {
        @Nullable
        @JsonProperty(value="input")
        public SinkRecord getInput();

        @Nullable
        @JsonProperty(value="output")
        public Object getOutput();
    }

    public static interface ConnectorExample
    extends Example {
        @JsonProperty(value="transformations")
        public Map<String, Map<String, String>> transformations();
    }

    public static interface Example
    extends Notes {
        @JsonProperty(value="name")
        public String getName();

        @JsonProperty(value="config")
        public Map<String, String> getConfig();
    }

    @Value.Immutable
    public static interface Transformation
    extends Configurable {
        public boolean isKeyValue();

        @Nullable
        public Class getKey();

        @Nullable
        public Class getValue();
    }

    @Value.Immutable
    public static interface SinkConnector
    extends Connector {
    }

    @Value.Immutable
    public static interface SourceConnector
    extends Connector {
    }

    public static interface Connector
    extends Configurable {
    }

    @Value.Immutable
    public static interface Configuration {
        public List<Group> getGroups();

        public List<Item> getRequiredConfigs();
    }

    public static interface Configurable
    extends Notes {
        public Class getCls();

        public Configuration getConfiguration();

        public List<String> getExamples();
    }

    @Value.Immutable
    public static interface Converter
    extends Notes {
        public Class getCls();
    }

    @Value.Immutable
    public static interface Group {
        public String getName();

        public List<Item> getItems();
    }

    @Value.Immutable
    public static interface Item {
        public String getName();

        public ConfigDef.Importance getImportance();

        public String getDoc();

        @Nullable
        public Object getDefaultValue();

        @Nullable
        public ConfigDef.Validator getValidator();

        public ConfigDef.Type getType();

        public String getGroup();

        public boolean isRequired();
    }
}

