/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.google.common.base.Preconditions;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;

public class SinkRecordHelper {
    public static final int PARTITION = 1;
    public static final long OFFSET = 91283741L;
    public static final long TIMESTAMP = 1530286549123L;

    public static SinkRecord delete(String topic, Struct key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null.");
        return SinkRecordHelper.delete(topic, new SchemaAndValue(key.schema(), (Object)key));
    }

    public static SinkRecord delete(String topic, Schema keySchema, Object key) {
        return SinkRecordHelper.delete(topic, new SchemaAndValue(keySchema, key));
    }

    public static SinkRecord delete(String topic, SchemaAndValue key) {
        Preconditions.checkNotNull((Object)topic, (Object)"topic cannot be null");
        if (null == key) {
            throw new DataException("key cannot be null.");
        }
        if (null == key.value()) {
            throw new DataException("key cannot be null.");
        }
        return new SinkRecord(topic, 1, key.schema(), key.value(), null, null, 91283741L, Long.valueOf(1530286549123L), TimestampType.CREATE_TIME);
    }

    public static SinkRecord write(String topic, Struct key, Struct value) {
        return SinkRecordHelper.write(topic, new SchemaAndValue(key.schema(), (Object)key), new SchemaAndValue(value.schema(), (Object)value));
    }

    public static SinkRecord write(String topic, Schema keySchema, Object key, Schema valueSchema, Object value) {
        return SinkRecordHelper.write(topic, new SchemaAndValue(keySchema, key), new SchemaAndValue(valueSchema, value));
    }

    public static SinkRecord write(String topic, SchemaAndValue key, SchemaAndValue value) {
        Preconditions.checkNotNull((Object)topic, (Object)"topic cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null.");
        Preconditions.checkNotNull((Object)key.value(), (Object)"key cannot be null.");
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null.");
        Preconditions.checkNotNull((Object)value.value(), (Object)"value cannot be null.");
        return new SinkRecord(topic, 1, key.schema(), key.value(), value.schema(), value.value(), 91283741L, Long.valueOf(1530286549123L), TimestampType.CREATE_TIME);
    }
}

