/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.model;

import com.github.jcustenborder.kafka.connect.utils.config.AnnotationHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configurable;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Example;
import com.github.jcustenborder.kafka.connect.utils.templates.model.SinkConnectorData;
import com.github.jcustenborder.kafka.connect.utils.templates.model.SourceConnectorData;
import com.github.jcustenborder.kafka.connect.utils.templates.model.TransformationData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.transforms.Transformation;

public class PluginData {
    final List<SourceConnectorData> sourceConnectors;
    final List<SinkConnectorData> sinkConnectors;
    final List<TransformationData> transformations;
    private final String warning;
    private final String tip;
    private final String important;
    private final String danger;
    private final String note;
    private final String introduction;
    private final String title;

    private PluginData(Package p, List<SourceConnectorData> sourceConnectors, List<SinkConnectorData> sinkConnectors, List<TransformationData> transformations) {
        this.sourceConnectors = ImmutableList.copyOf(sourceConnectors);
        this.sinkConnectors = ImmutableList.copyOf(sinkConnectors);
        this.transformations = ImmutableList.copyOf(transformations);
        this.warning = AnnotationHelper.warning((Package)p);
        this.tip = AnnotationHelper.tip((Package)p);
        this.important = AnnotationHelper.important((Package)p);
        this.danger = AnnotationHelper.danger((Package)p);
        this.note = AnnotationHelper.note((Package)p);
        this.introduction = AnnotationHelper.introduction((Package)p);
        this.title = AnnotationHelper.title((Package)p);
    }

    public static PluginData from(Package pkg, Set<String> resources, List<Class<? extends SourceConnector>> sourceConnectorClasses, List<Class<? extends SinkConnector>> sinkConnectorClasses, List<Class<? extends Transformation>> transformationClasses) {
        List<SourceConnectorData> sourceConnectors = sourceConnectorClasses.stream().map(SourceConnectorData::new).collect(Collectors.toList());
        for (Configurable configurable : sourceConnectors) {
            List<Example> list = resources.stream().filter(p -> p.startsWith(configurable.getResourceFilter())).map(p -> Example.load(configurable.getCls(), "/" + p)).collect(Collectors.toList());
            configurable.setExamples(list);
        }
        List<SinkConnectorData> sinkConnectors = sinkConnectorClasses.stream().map(SinkConnectorData::new).collect(Collectors.toList());
        for (Configurable configurable : sinkConnectors) {
            List<Example> list = resources.stream().filter(p -> p.startsWith(template.getResourceFilter())).map(p -> Example.load(template.getCls(), "/" + p)).collect(Collectors.toList());
            configurable.setExamples(list);
        }
        List<TransformationData> list = transformationClasses.stream().map(TransformationData::new).collect(Collectors.toList());
        for (Configurable configurable : list) {
            List<Example> examples = resources.stream().filter(configurable.resourceFilter()).map(p -> Example.load(template.getCls(), "/" + p)).collect(Collectors.toList());
            configurable.setExamples(examples);
        }
        return new PluginData(pkg, sourceConnectors, sinkConnectors, list);
    }

    public List<Configurable> all() {
        ArrayList<Configurable> all = new ArrayList<Configurable>();
        all.addAll(this.sourceConnectors);
        all.addAll(this.sinkConnectors);
        all.addAll(this.transformations);
        return ImmutableList.copyOf(all);
    }

    public List<SourceConnectorData> getSourceConnectors() {
        return this.sourceConnectors;
    }

    public List<SinkConnectorData> getSinkConnectors() {
        return this.sinkConnectors;
    }

    public List<TransformationData> getTransformations() {
        return this.transformations;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public String getNote() {
        return this.note;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public String getTitle() {
        return this.title;
    }
}

