/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.SinkConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.SourceConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.TransformationTemplate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.transforms.Transformation;

public class PluginTemplate {
    final List<SourceConnectorTemplate> sourceConnectors;
    final List<SinkConnectorTemplate> sinkConnectors;
    final List<TransformationTemplate> transformations;

    private PluginTemplate(List<SourceConnectorTemplate> sourceConnectors, List<SinkConnectorTemplate> sinkConnectors, List<TransformationTemplate> transformations) {
        this.sourceConnectors = ImmutableList.copyOf(sourceConnectors);
        this.sinkConnectors = ImmutableList.copyOf(sinkConnectors);
        this.transformations = ImmutableList.copyOf(transformations);
    }

    public List<SourceConnectorTemplate> getSourceConnectors() {
        return this.sourceConnectors;
    }

    public List<SinkConnectorTemplate> getSinkConnectors() {
        return this.sinkConnectors;
    }

    public List<TransformationTemplate> getTransformations() {
        return this.transformations;
    }

    public static PluginTemplate from(List<Class<? extends SourceConnector>> sourceConnectorClasses, List<Class<? extends SinkConnector>> sinkConnectorClasses, List<Class<? extends Transformation>> transformationClasses) {
        List<SourceConnectorTemplate> sourceConnectors = sourceConnectorClasses.stream().map(aClass -> new SourceConnectorTemplate((Class<?>)aClass)).collect(Collectors.toList());
        List<SinkConnectorTemplate> sinkConnectors = sinkConnectorClasses.stream().map(aClass -> new SinkConnectorTemplate((Class<?>)aClass)).collect(Collectors.toList());
        List<TransformationTemplate> transformations = transformationClasses.stream().map(aClass -> new TransformationTemplate((Class<?>)aClass)).collect(Collectors.toList());
        return new PluginTemplate(sourceConnectors, sinkConnectors, transformations);
    }
}

