/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.templates.ConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.PluginTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.SourceConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateSchema;
import com.github.jcustenborder.kafka.connect.utils.templates.TransformationTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.markdown.MarkdownTemplateHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.rst.RstTemplateHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.RankDir;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    static Configuration configuration;
    static ClassTemplateLoader loader;
    Reflections reflections;
    PluginTemplate pluginTemplate;
    final File outputDirectory = new File("target/docs");

    protected List<Schema> schemas() {
        return Arrays.asList(new Schema[0]);
    }

    protected abstract String[] packages();

    @BeforeAll
    public static void loadTemplates() {
        loader = new ClassTemplateLoader(BaseDocumentationTest.class, "templates");
        configuration = new Configuration(Configuration.getVersion());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateLoader((TemplateLoader)loader);
        configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.getVersion()));
    }

    <T> List<Class<? extends T>> list(Class<T> cls) {
        List<Class<T>> classes = this.reflections.getSubTypesOf(cls).stream().filter(aClass -> !Modifier.isAbstract(aClass.getModifiers()) && Modifier.isPublic(aClass.getModifiers())).collect(Collectors.toList());
        classes.sort(Comparator.comparing(Class::getName));
        return classes;
    }

    @BeforeEach
    public void before() throws MalformedURLException {
        log.info("before() - Configuring reflections to use package '{}'", (Object[])this.packages());
        if (null == this.reflections) {
            this.reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(this.packages()));
        }
        List<Class<? extends Transformation>> transformClasses = this.list(Transformation.class);
        List<Class<? extends SourceConnector>> sourceConnectorClasses = this.list(SourceConnector.class);
        List<Class<? extends SinkConnector>> sinkConnectorClasses = this.list(SinkConnector.class);
        this.pluginTemplate = PluginTemplate.from(sourceConnectorClasses, sinkConnectorClasses, transformClasses);
    }

    protected List<Map.Entry<String, ConfigDef.ConfigKey>> required(ConfigDef configDef) {
        ArrayList entries = new ArrayList();
        for (Map.Entry kvp : configDef.configKeys().entrySet()) {
            if (((ConfigDef.ConfigKey)kvp.getValue()).hasDefault()) continue;
            entries.add(kvp);
        }
        return ImmutableList.copyOf(entries);
    }

    DynamicTest connectorRstTest(ConnectorTemplate connectorTemplate, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        return DynamicTest.dynamicTest((String)connectorTemplate.getSimpleName(), () -> {
            File graphOutputFile = new File(parentDirectory, connectorTemplate.getDiagramFileName());
            Graph g = connectorTemplate instanceof SourceConnectorTemplate ? ((Graph)Factory.graph().graphAttr().with((Attributes)RankDir.LEFT_TO_RIGHT)).directed().with(new LinkSource[]{((Node)Factory.node((String)connectorTemplate.getSimpleName()).with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka Connect").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka").with((Attributes)Shape.RECTANGLE))).with((Attributes)Label.of((String)"Writes messages to"))})).with((Attributes)Label.of((String)"Hosted by"))})}) : ((Graph)Factory.graph().graphAttr().with((Attributes)RankDir.LEFT_TO_RIGHT)).directed().with(new LinkSource[]{((Node)Factory.node((String)"Kafka").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka Connect").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)connectorTemplate.getSimpleName()).with((Attributes)Shape.RECTANGLE))).with((Attributes)Label.of((String)"Writes data to"))})).with((Attributes)Label.of((String)"Pulls Data from"))})});
            Graphviz.fromGraph((Graph)g).width(350).render(Format.SVG_STANDALONE).toFile(graphOutputFile);
            File outputFile = new File(parentDirectory, connectorTemplate.getSimpleName() + ".rst");
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, connectorTemplate);
            }
        });
    }

    DynamicTest transformRstTest(TransformationTemplate transformationTemplate, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        String testName = transformationTemplate.getTestName();
        return DynamicTest.dynamicTest((String)testName, () -> {
            File outputFile = new File(parentDirectory, testName.toLowerCase() + ".rst");
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, transformationTemplate);
            }
        });
    }

    @TestFactory
    public Stream<DynamicTest> sources() {
        File parentDirectory = new File(this.outputDirectory, "sources");
        String templateName = "rst/source.rst.ftl";
        return this.pluginTemplate.getSourceConnectors().stream().map(connectorTemplate -> this.connectorRstTest((ConnectorTemplate)connectorTemplate, "rst/source.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> sinks() {
        File parentDirectory = new File(this.outputDirectory, "sinks");
        String templateName = "rst/sink.rst.ftl";
        return this.pluginTemplate.getSinkConnectors().stream().map(connectorTemplate -> this.connectorRstTest((ConnectorTemplate)connectorTemplate, "rst/sink.rst.ftl", parentDirectory));
    }

    void process(Writer writer, Template template, Object input) throws IOException, TemplateException {
        ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)input, (Object)"rstHelper", (Object)new RstTemplateHelper(), (Object)"markdownHelper", (Object)new MarkdownTemplateHelper());
        template.process((Object)variables, writer);
    }

    @TestFactory
    public Stream<DynamicTest> transformations() {
        File parentDirectory = new File(this.outputDirectory, "transformations");
        String templateName = "rst/transformation.rst.ftl";
        return this.pluginTemplate.getTransformations().stream().map(connectorTemplate -> this.transformRstTest((TransformationTemplate)connectorTemplate, "rst/transformation.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> schema() throws IOException {
        List<Schema> schemas;
        File parentDirectory = new File(this.outputDirectory, "schemas");
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        if (null != (schemas = this.schemas()) && !schemas.isEmpty()) {
            File schemaRstPath = new File(this.outputDirectory, "schemas.rst");
            String schemaRst = "=======\nSchemas\n=======\n\n.. toctree::\n    :maxdepth: 0\n    :caption: Schemas:\n    :glob:\n\n    schemas/*";
            Files.write((CharSequence)"=======\nSchemas\n=======\n\n.. toctree::\n    :maxdepth: 0\n    :caption: Schemas:\n    :glob:\n\n    schemas/*", (File)schemaRstPath, (Charset)Charsets.UTF_8);
        }
        String templateName = "rst/schema.rst.ftl";
        return this.schemas().stream().filter(schema -> !Strings.isNullOrEmpty((String)schema.name())).map(schema -> DynamicTest.dynamicTest((String)String.format("%s.%s", schema.type(), schema.name()), () -> {
            StringBuilder filenameBuilder = new StringBuilder().append(schema.type().toString().toLowerCase());
            if (!Strings.isNullOrEmpty((String)schema.name())) {
                filenameBuilder.append('.').append(schema.name());
            }
            filenameBuilder.append(".rst");
            File outputFile = new File(parentDirectory, filenameBuilder.toString());
            Template template = configuration.getTemplate("rst/schema.rst.ftl");
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)TemplateSchema.of(schema), (Object)"helper", (Object)new RstTemplateHelper());
                template.process((Object)variables, (Writer)writer);
            }
        }));
    }

    @Test
    public void rst() throws IOException, TemplateException {
        File outputFile = new File("target", "README.rst");
        Template template = configuration.getTemplate("rst/README.rst.ftl");
        log.info("Writing {}", (Object)outputFile);
        try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
            this.process(writer, template, this.pluginTemplate);
        }
    }

    @Test
    public void markdown() throws IOException, TemplateException {
        String output;
        File outputFile = new File("target", "README.md");
        Template template = configuration.getTemplate("md/README.md.ftl");
        try (StringWriter writer = new StringWriter();){
            writer.write(10);
            this.process(writer, template, this.pluginTemplate);
            output = writer.toString();
        }
        log.info("\n{}", (Object)output);
        Files.write((CharSequence)output, (File)outputFile, (Charset)Charsets.UTF_8);
    }
}

