/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Table;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class TemplateSchema
implements Table {
    private final Schema schema;

    public Schema getSchema() {
        return this.schema;
    }

    private TemplateSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getTitle() {
        String result = Strings.isNullOrEmpty((String)this.schema.name()) ? "" : Files.getFileExtension((String)this.schema.name());
        return result;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("Name", "Type", "Optional", "Default Value", "Documentation");
    }

    String type(Schema schema) {
        String result;
        switch (schema.type()) {
            case ARRAY: {
                result = String.format("Array of %s", this.type(schema.valueSchema()));
                break;
            }
            case MAP: {
                result = String.format("Map of %s, %s", this.type(schema.keySchema()), this.type(schema.valueSchema()));
                break;
            }
            default: {
                result = String.format(":ref:`schema-%s`", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, schema.type().toString()));
            }
        }
        return result;
    }

    @Override
    public List<String[]> getRowData() {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        if (Schema.Type.STRUCT != this.schema.type()) {
            return rows;
        }
        for (Field field : this.schema.fields()) {
            rows.add(new String[]{field.name(), this.type(field.schema()), String.format("%s", field.schema().isOptional()), null != field.schema().defaultValue() ? field.schema().defaultValue().toString() : "", field.schema().doc()});
        }
        return rows;
    }

    public static TemplateSchema of(Schema schema) {
        return new TemplateSchema(schema);
    }
}

