/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl;
import java.util.Objects;

public class ServiceSpecBuilder
extends ServiceSpecFluentImpl<ServiceSpecBuilder>
implements VisitableBuilder<ServiceSpec, ServiceSpecBuilder> {
    ServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceSpecBuilder() {
        this(true);
    }

    public ServiceSpecBuilder(Boolean validationEnabled) {
        this(new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, ServiceSpec instance) {
        this(fluent, instance, true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        fluent.withClusterIP(instance.getClusterIP());
        fluent.withClusterIPs(instance.getClusterIPs());
        fluent.withExternalIPs(instance.getExternalIPs());
        fluent.withExternalName(instance.getExternalName());
        fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        fluent.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        fluent.withIpFamilies(instance.getIpFamilies());
        fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
        fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        fluent.withPorts(instance.getPorts());
        fluent.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        fluent.withSelector(instance.getSelector());
        fluent.withSessionAffinity(instance.getSessionAffinity());
        fluent.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        fluent.withTopologyKeys(instance.getTopologyKeys());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ServiceSpecBuilder(ServiceSpec instance) {
        this(instance, (Boolean)true);
    }

    public ServiceSpecBuilder(ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        this.withClusterIP(instance.getClusterIP());
        this.withClusterIPs(instance.getClusterIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withExternalName(instance.getExternalName());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        this.withIpFamilies(instance.getIpFamilies());
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPorts(instance.getPorts());
        this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        this.withTopologyKeys(instance.getTopologyKeys());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ServiceSpec build() {
        ServiceSpec buildable = new ServiceSpec(this.fluent.isAllocateLoadBalancerNodePorts(), this.fluent.getClusterIP(), this.fluent.getClusterIPs(), this.fluent.getExternalIPs(), this.fluent.getExternalName(), this.fluent.getExternalTrafficPolicy(), this.fluent.getHealthCheckNodePort(), this.fluent.getIpFamilies(), this.fluent.getIpFamilyPolicy(), this.fluent.getLoadBalancerIP(), this.fluent.getLoadBalancerSourceRanges(), this.fluent.getPorts(), this.fluent.isPublishNotReadyAddresses(), this.fluent.getSelector(), this.fluent.getSessionAffinity(), this.fluent.getSessionAffinityConfig(), this.fluent.getTopologyKeys(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecBuilder that = (ServiceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

